<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-09-22
 ******************************************************************************/

namespace Fastmag\Sync\Model;

use Magento\Framework\App\MutableScopeConfig;

/**
 * Class Config
 *
 * Config getter for all Fastmag Sync classes
 * Substitute ScopeConfig class and contains all the config fields added by the plugin
 */
class Config extends MutableScopeConfig
{
    /** @var string */
    public const XML_PATH_ABOUT_WEBSITE_ID = 'fastmag_sync_about/technical_data/website_id';

    /** @var string */
    public const XML_PATH_CONNECT_PRECONFIG_TODO = 'fastmag_sync_connect/state/preconfig_todo';

    /** @var string */
    public const XML_PATH_CONNECT_API_HOST = 'fastmag_sync_connect/api/host';

    /** @var string */
    public const XML_PATH_CONNECT_API_CHAIN = 'fastmag_sync_connect/api/chain';

    /** @var string */
    public const XML_PATH_CONNECT_API_SHOP = 'fastmag_sync_connect/api/shop';

    /** @var string */
    public const XML_PATH_CONNECT_API_USER = 'fastmag_sync_connect/api/user';

    /** @var string */
    public const XML_PATH_CONNECT_API_PASSWORD = 'fastmag_sync_connect/api/password';

    /** @var string */
    public const XML_PATH_CONNECT_PROXY_USER = 'fastmag_sync_connect/proxy/user';

    /** @var string */
    public const XML_PATH_CONNECT_PROXY_PASSWORD = 'fastmag_sync_connect/proxy/password';

    /** @var string */
    public const XML_PATH_CONNECT_PROXY_NATIVE_SQL_CONNECTION = 'fastmag_sync_connect/proxy/native_sql_connection';

    /** @var string */
    public const XML_PATH_JOBQUEUE_SYNC_ENABLED = 'fastmag_sync_jobqueue/sync/enable';

    /** @var string */
    public const XML_PATH_JOBQUEUE_ADVANCED_REACTIVITY = 'fastmag_sync_jobqueue/advanced/reactivity';

    /** @var string */
    public const XML_PATH_JOBQUEUE_ADVANCED_JOBS_LIMIT = 'fastmag_sync_jobqueue/advanced/jobs_limit';

    /** @var string */
    public const XML_PATH_JOBQUEUE_ADVANCED_HYDRATION_SIZE = 'fastmag_sync_jobqueue/advanced/hydration_size';

    /** @var string */
    public const XML_PATH_PRODUCT_IMPORT_ENABLE = 'fastmag_sync_products/import/enable';

    /** @var string */
    public const XML_PATH_PRODUCT_IMPORT_ONLY_INVENTORY = 'fastmag_sync_products/import/only_inventory';

    /** @var string */
    public const XML_PATH_PRODUCT_IMPORT_ACTIVE_VISIBLEWEB = 'fastmag_sync_products/import/only_active_visibleweb';

    /** @var string */
    public const XML_PATH_PRODUCT_IMPORT_ONLY_DEFINED_STOCKS = 'fastmag_sync_products/import/only_defined_stocks';

    /** @var string */
    public const XML_PATH_PRODUCT_IMPORT_ATTRIBUTE_SET_ID = 'fastmag_sync_products/import/attribute_set_id';

    /** @var string */
    public const XML_PATH_PRODUCT_IMPORT_MANAGE_PRODUCT_STATUS = 'fastmag_sync_products/import/manage_product_status';

    /** @var string */
    public const XML_PATH_PRODUCT_CATALOG_UNIQUE_COMBINATION
        = 'fastmag_sync_products/catalog_architecture/configurable_unique_combination';

    /** @var string */
    public const XML_PATH_PRODUCT_CONFIGURABLE_ATTRIBUTES_COLOR
        = 'fastmag_sync_products/configurable_attributes/default_color_attribute';

    /** @var string */
    public const XML_PATH_PRODUCT_CONFIGURABLE_ATTRIBUTES_USE_COLOR_DESCRIPTION
        = 'fastmag_sync_products/configurable_attributes/use_color_description';

    /** @var string */
    public const XML_PATH_PRODUCT_CONFIGURABLE_ATTRIBUTES_INTERNAL_COLOR
        = 'fastmag_sync_products/configurable_attributes/internal_color_attribute';

    /** @var string */
    public const XML_PATH_PRODUCT_CONFIGURABLE_ATTRIBUTES_SIZE
        = 'fastmag_sync_products/configurable_attributes/default_size_attribute';

    /** @var string */
    public const XML_PATH_PRODUCT_CONFIGURABLE_ATTRIBUTES_UNIQUE_SIZE
        = 'fastmag_sync_products/configurable_attributes/replace_empty_size';

    /** @var string */
    public const XML_PATH_PRODUCT_CONFIGURABLE_ATTRIBUTES_UNIQUE_SIZE_LABEL
        = 'fastmag_sync_products/configurable_attributes/unique_size_label';

    /** @var string */
    public const XML_PATH_PRODUCT_PRICE_MANAGE_TIER_PRICES = 'fastmag_sync_products/price/manage_tiers_price';

    /** @var string */
    public const XML_PATH_PRODUCT_PRICE_FASTMAG_RATE = 'fastmag_sync_products/price/fastmag_rate';

    /** @var string */
    public const XML_PATH_PRODUCT_OTHER_ATTRIBUTES_LANGUAGE = 'fastmag_sync_products/other_attributes/language';

    /** @var string */
    public const XML_PATH_PRODUCT_OTHER_ATTRIBUTES_SYNC_CREATION_DATE
        = 'fastmag_sync_products/other_attributes/use_fastmag_creation_date';

    /** @var string */
    public const XML_PATH_PRODUCT_OTHER_ATTRIBUTES_SYNC_DESCRIPTION
        = 'fastmag_sync_products/other_attributes/sync_description';

    /** @var string */
    public const XML_PATH_PRODUCT_OTHER_ATTRIBUTES_SYNC_FAMILY = 'fastmag_sync_products/other_attributes/sync_family';

    /** @var string */
    public const XML_PATH_PRODUCT_OTHER_ATTRIBUTES_SYNC_SUBFAMILY
        = 'fastmag_sync_products/other_attributes/sync_subfamily';

    /** @var string */
    public const XML_PATH_PRODUCT_OTHER_ATTRIBUTES_SYNC_SECTION = 'fastmag_sync_products/other_attributes/sync_section';

    /** @var string */
    public const XML_PATH_PRODUCT_OTHER_ATTRIBUTES_SYNC_SEASON = 'fastmag_sync_products/other_attributes/sync_season';

    /** @var string */
    public const XML_PATH_PRODUCT_OTHER_ATTRIBUTES_SYNC_MODEL = 'fastmag_sync_products/other_attributes/sync_model';

    /** @var string */
    public const XML_PATH_PRODUCT_OTHER_ATTRIBUTES_SYNC_MATERIAL
        = 'fastmag_sync_products/other_attributes/sync_material';

    /** @var string */
    public const XML_PATH_PRODUCT_OTHER_ATTRIBUTES_SYNC_THEME = 'fastmag_sync_products/other_attributes/sync_theme';

    /** @var string */
    public const XML_PATH_PRODUCT_OTHER_ATTRIBUTES_SYNC_TEXTILE
        = 'fastmag_sync_products/other_attributes/sync_textile_attributes';

    /** @var string */
    public const XML_PATH_PRODUCT_OTHER_ATTRIBUTES_SYNC_IS_NEW = 'fastmag_sync_products/other_attributes/sync_is_new';

    /** @var string */
    public const XML_PATH_INVENTORY_FASTMAG_STOCK_REFERENCE_STOCK
        = 'fastmag_sync_inventory/fastmag_stock/reference_stock';

    /** @var string */
    public const XML_PATH_INVENTORY_FASTMAG_STOCK_ALTERNATIVE_STOCKS
        = 'fastmag_sync_inventory/fastmag_stock/alternative_stocks';

    /** @var string */
    public const XML_PATH_INVENTORY_MSI_SOURCE = 'fastmag_sync_inventory/msi/source';

    /** @var string */
    public const XML_PATH_CUSTOMER_EXPORT_ENABLE = 'fastmag_sync_customers/export/enable';

    /** @var string */
    public const XML_PATH_CUSTOMER_DELETION_ENABLE = 'fastmag_sync_customers/deletion/enable';

    /** @var string */
    public const XML_PATH_ORDER_SYNC_ENABLE = 'fastmag_sync_orders/sync/enable';

    /** @var string */
    public const XML_PATH_ORDER_WORKFLOW_CHAIN = 'fastmag_sync_orders/workflow/chain';

    /** @var string */
    public const XML_PATH_ORDER_WORKFLOW_SHOP = 'fastmag_sync_orders/workflow/shop';

    /** @var string */
    public const XML_PATH_ORDER_WORKFLOW_SELLER = 'fastmag_sync_orders/workflow/seller';

    /** @var string */
    public const XML_PATH_ORDER_WORKFLOW_INVENTORY_TRANSFER = 'fastmag_sync_orders/workflow/inventory_transfer';

    /** @var string */
    public const XML_PATH_ORDER_WORKFLOW_FASTMAG_STATUS = 'fastmag_sync_orders/workflow/fastmag_status';

    /** @var string */
    public const XML_PATH_ORDER_ALERT_ENABLE_FOR_TRANSFER = 'fastmag_sync_orders/alert/enable_for_transfer';

    /** @var string */
    public const XML_PATH_ORDER_ALERT_ENABLE_FOR_SALE = 'fastmag_sync_orders/alert/enable_for_sale';

    /** @var string */
    public const XML_PATH_LOG_ENABLE = 'fastmag_sync_logs/logs/enable';

    /** @var string */
    public const XML_PATH_LOG_ROTATION_DELAY = 'fastmag_sync_logs/logs/rotation_delay';

    /** @var string */
    public const XML_PATH_LOG_TO_FILE = 'fastmag_sync_logs/logs/to_file';

    /** @var string */
    public const XML_PATH_LOG_API_CALLS = 'fastmag_sync_logs/logs/log_api_calls';
}
