<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-09-27
 ******************************************************************************/

namespace Fastmag\Sync\Model\Jobqueue;

use Exception;
use Fastmag\Sync\Model\Jobqueue as AbstractJob;
use Fastmag\Sync\Process\EntityInterface;

/**
 * Class StandardRepository
 *
 * Standard job repository class
 *
 * @method AbstractJob save($job)
 */
abstract class StandardRepository
{
    /**
     * Hydrate job with entity
     *
     * @param AbstractJob     $job
     * @param EntityInterface $entity
     *
     * @return AbstractJob
     */
    public function hydrate($job, $entity)
    {
        $job->setHydratedData($entity->export())
            ->setEntity($entity);

        return $job;
    }

    /**
     * Validate job
     *
     * @param AbstractJob $job
     *
     * @return AbstractJob
     */
    public function validate($job)
    {
        $job->setStatus(AbstractJob::STATUS_SUCCESS)
            ->setProcessedAt(date('Y-m-d H:i:s'));

        return $job;
    }

    /**
     * Invalidate job
     *
     * @param AbstractJob  $job
     * @param Exception $exception
     *
     * @return AbstractJob
     */
    public function invalidate($job, $exception)
    {
        $oldMessages = $job->getMessage();
        $oldTrace = $job->getTrace();

        $job->setMessage(trim($oldMessages . "\n" . $exception->getMessage()))
            ->setTrace(trim($oldTrace . "\n" . $exception->getTraceAsString()))
            ->setStatus(AbstractJob::STATUS_ERROR);

        return $job;
    }

    /**
     * Skip job
     *
     * @param AbstractJob $job
     *
     * @return AbstractJob
     */
    public function skip($job, $exception)
    {
        $oldMessages = $job->getMessage();
        $oldTrace = $job->getTrace();

        $job->setMessage(trim($oldMessages . "\n" . $exception->getMessage()))
            ->setTrace(trim($oldTrace . "\n" . $exception->getTraceAsString()))
            ->setStatus(AbstractJob::STATUS_SKIPPED)
            ->setProcessedAt(date('Y-m-d H:i:s'));

        return $job;
    }
}
