<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-09-28
 ******************************************************************************/

namespace Fastmag\Sync\Plugin\Jobqueue\ToFastmag;

use Fastmag\Sync\Plugin\Jobqueue\ToFastmag;
use Magento\Framework\Exception\CouldNotSaveException;
use Magento\Sales\Api\Data\OrderInterface;
use Magento\Sales\Api\OrderRepositoryInterface;
use Magento\Sales\Model\Order;

/**
 * Class OrderRepositoryPlugin
 *
 * Plugin on OrderRepositoryInterface
 */
class OrderRepositoryPlugin extends ToFastmag
{
    /**
     * @see OrderRepositoryInterface::save()
     *
     * @param OrderRepositoryInterface $subject
     * @param OrderInterface           $order
     *
     * @return OrderInterface
     */
    public function afterSave(OrderRepositoryInterface $subject, $order)
    {
        if ($order->getEntityId()
            && $order->getPayment()
            && !$this->isCalledByFastmagModule()
            && !in_array($order->getState(), ['', Order::STATE_CLOSED, Order::STATE_CANCELED], true)
        ) {
            try {
                $key = $order->getEntityId() . '_' . $order->getStatus();

                $job = $this->jobFactory->create();
                $job->setContentId($key)
                    ->setJobCode('tofastmag_integration_order');

                $this->jobRepository->save($job);
            } catch (CouldNotSaveException $exception) {
                $this->logger->error($exception->getMessage());
            }
        }

        return $order;
    }

    /**
     * Check, in the backtrace, if the order save is called from within the FastmagSync module
     *
     * @return bool
     */
    protected function isCalledByFastmagModule()
    {
        $result = false;

        $trace = debug_backtrace();

        foreach ($trace as $call) {
            if (preg_match('/Fastmag(\\\\)?Sync/', $call['class']) && $call['class'] !== get_class($this)) {
                $result = true;

                break;
            }
        }

        return $result;
    }
}
