<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-09-27
 ******************************************************************************/

namespace Fastmag\Sync\Process\Worker\ToFastmag\Integration\Order;

use Fastmag\Sync\Api\Data\Rule\OrdertransactionInterface as OrdertransactionRule;
use Fastmag\Sync\Exception\JobException;
use Fastmag\Sync\Process\Entity\ToFastmag\Order as OrderEntity;
use Fastmag\Sync\Process\Worker\ToFastmag\Integration\Order;

/**
 * Class Cancellation
 *
 * Integration class used for cancelling orders in Fastmag
 */
class Cancellation extends Order
{
    /** @inheritDoc */
    protected $code = 'tofastmag_integration_order_cancellation';

    /** @var string $hydrationWorker */
    protected $hydrationWorker = 'tofastmag_hydration_order';

    /** @var string[] $subordinateWorkersAfter */
    protected $subordinateWorkersAfter = [
        'tofastmag_integration_order_cancellation_transfer'
    ];

    /**
     * @inheritDoc
     */
    protected function processJob($job)
    {
        /** @var OrderEntity $orderEntity */
        $this->currentEntity = $job->getEntity();

        if (!$this->isTransactionCancellation($this->currentEntity->getTransactionType())) {
            throw new JobException(__('Order is not cancelled, impossible to send a cancellation'));
        }

//        $requestAt = date('Y-m-d H:i:s');
//
//        $this->sendCancellation();
//
//        $this->saveSyncOrder($requestAt);
    }

    /**
     * Check if the transaction is a sale or reservation cancellation
     *
     * @param string $transactionType
     *
     * @return bool
     */
    protected function isTransactionCancellation($transactionType)
    {
        return in_array($transactionType, [
            OrdertransactionRule::FASTMAG_TRANSACTION_TYPE_SALE_CANCELLATION,
            OrdertransactionRule::FASTMAG_TRANSACTION_TYPE_RESERVATION_CANCELLATION
        ], true);
    }
}
