<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-07-23
 ******************************************************************************/

namespace Fastmag\Sync\Controller\Adminhtml\Preconfig;

use Exception;
use Fastmag\Sync\Logger\Logger;
use Fastmag\Sync\Model\Config;
use Fastmag\Sync\Model\System\Preconfig\File;
use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Framework\App\Config\Storage\WriterInterface;

/**
 * Class Delete
 *
 * Preconfig folder delete action
 */
class Delete extends Action
{
    /** @var string */
    public const ADMIN_RESOURCE = 'Fastmag_Sync::preconfig';

    /** @var Logger $logger */
    protected $logger;

    /** @var File $file */
    protected $file;

    /** @var WriterInterface $configWriter */
    protected $configWriter;

    /** @var Config $config */
    protected $config;

    /**
     * Delete constructor
     *
     * @param Context         $context
     * @param Logger          $logger
     * @param File            $file
     * @param WriterInterface $writer
     * @param Config          $config
     */
    public function __construct(
        Context $context,
        Logger $logger,
        File $file,
        WriterInterface $writer,
        Config $config
    ) {
        parent::__construct($context);

        $this->logger = $logger;
        $this->file = $file;
        $this->configWriter = $writer;
        $this->config = $config;
    }

    /**
     * @inheritDoc
     */
    public function execute()
    {
        try {
            $this->file->delete();

            $this->configWriter->save(Config::XML_PATH_CONNECT_PRECONFIG_TODO, 0);
            $this->config->clean();
        } catch (Exception $exception) {
            $message = __(
                'Unable to delete the directory. Please contact Home-made.io ASAP. Error: %1',
                $exception->getMessage()
            )->render();
            $this->logger->critical($message);
            $this->messageManager->addErrorMessage($message);
        }

        /* @todo > 1.0.0 : redirect to current page instead */
        $resultRedirect = $this->resultRedirectFactory->create();
        $resultRedirect->setPath('adminhtml');

        return $resultRedirect;
    }
}
