<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-08-09
 ******************************************************************************/

namespace Fastmag\Sync\Block\Adminhtml\Rule\Ordertransaction\Edit\Button;

use Fastmag\Sync\Api\Rule\OrdertransactionRepositoryInterface as RuleRepository;
use Magento\Backend\Block\Widget\Context;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\Exception\NoSuchEntityException;

/**
 * Class Generic
 *
 * Generic button class for Ordertransaction rules admin pages
 *
 * @todo change architecture to avoid code duplication
 */
class Generic
{
    /** @var Context $context */
    protected $context;

    /** @var RuleRepository $ruleRepository */
    protected $ruleRepository;

    /**
     * Generic constructor
     *
     * @param Context        $context
     * @param RuleRepository $ruleRepository
     */
    public function __construct(
        Context $context,
        RuleRepository $ruleRepository
    ) {
        $this->context = $context;
        $this->ruleRepository = $ruleRepository;
    }

    /**
     * Return rule ID
     *
     * @return int|null
     *
     * @throws LocalizedException
     */
    public function getRuleId()
    {
        try {
            return $this->ruleRepository->getById(
                $this->context->getRequest()->getParam('id')
            )->getId();
        } catch (NoSuchEntityException $exception) {
            // No entity
        }

        return null;
    }

    /**
     * Generate URL by route and parameters
     *
     * @param string $route
     * @param array  $params
     *
     * @return string
     */
    public function getUrl($route = '', $params = [])
    {
        return $this->context->getUrlBuilder()->getUrl($route, $params);
    }
}
