<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-09-22
 ******************************************************************************/

namespace Fastmag\Sync\Process\Worker\ToFastmag\Integration\Order;

use Fastmag\Sync\Api\Data\Rule\OrdertransactionInterface as OrdertransactionRule;
use Fastmag\Sync\Exception\JobException;
use Fastmag\Sync\Model\Config;
use Fastmag\Sync\Process\Entity\ToFastmag\Order as OrderEntity;
use Fastmag\Sync\Process\Worker\ToFastmag\Integration\Customer\Data as StandardCustomer;

/**
 * Class Customer
 *
 * Integration class used for inserting or updating orders customers from Magento to Fastmag
 */
class Customer extends StandardCustomer
{
    /** @inheritDoc */
    protected $code = 'tofastmag_integration_order_customer';

    /** @var string[] $subordinateWorkersAfter */
    protected $subordinateWorkersAfter = [];

    /**
     * @inheritDoc
     */
    public function isEnabled()
    {
        return $this->config->isSetFlag(Config::XML_PATH_ORDER_SYNC_ENABLE);
    }

    /**
     * @inheritDoc
     */
    protected function processJob($job)
    {
        /** @var OrderEntity $orderEntity */
        $orderEntity = $job->getEntity();

        if ($this->useCustomerData($orderEntity->getTransactionType())) {
            parent::processJob($job);
        }
    }

    /**
     * @inheritDoc
     *
     * @throws JobException
     */
    protected function getCustomerEntity($job)
    {
        /** @var OrderEntity $orderEntity */
        $orderEntity = $job->getEntity();

        $result = $orderEntity->getCustomer();
        if ($result === null) {
            throw new JobException(__('No customer for order #%1', $orderEntity->getIncrementId()));
        }

        $billingAddress = $orderEntity->getBillingAddress();
        if ($billingAddress === null) {
            throw new JobException(__('No billing address for order #%1', $orderEntity->getIncrementId()));
        }

        $result->setBillingAddress($billingAddress);

        return $result;
    }

    /**
     * Returns true if the transaction use customer data
     *
     * @param string|null $transactionType
     *
     * @return bool
     */
    protected function useCustomerData($transactionType)
    {
        return $transactionType === null || in_array(
            $transactionType,
            [
                OrdertransactionRule::FASTMAG_TRANSACTION_TYPE_SALE,
                OrdertransactionRule::FASTMAG_TRANSACTION_TYPE_RESERVATION,
                OrdertransactionRule::FASTMAG_TRANSACTION_TYPE_ORDER,
                OrdertransactionRule::FASTMAG_TRANSACTION_TYPE_RESERVATIONTOSALE
            ],
            true
        );
    }
}
