<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-09-30
 ******************************************************************************/

namespace Fastmag\Sync\Api\Rule;

use Fastmag\Sync\Api\Data\Rule\CarrierInterface;
use Magento\Framework\Api\SearchCriteriaInterface;

/**
 * Interface ShippingmethodRepositoryInterface
 */
interface CarrierRepositoryInterface
{
    /**
     * Save rule.
     *
     * @param \Fastmag\Sync\Api\Data\Rule\CarrierInterface $rule
     *
     * @return \Fastmag\Sync\Api\Data\Rule\CarrierInterface
     *
     * @throws \Magento\Framework\Exception\CouldNotSaveException
     */
    public function save(CarrierInterface $rule);

    /**
     * Retrieve rule.
     *
     * @param int $ruleId
     *
     * @return \Fastmag\Sync\Api\Data\Rule\CarrierInterface
     *
     * @throws \Magento\Framework\Exception\LocalizedException
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function getById($ruleId);

    /**
     * Retrieve rules matching the specified criteria.
     *
     * @param \Magento\Framework\Api\SearchCriteriaInterface $searchCriteria
     *
     * @return \Fastmag\Sync\Api\Data\Rule\CarrierSearchResultsInterface
     */
    public function getList(SearchCriteriaInterface $searchCriteria);

    /**
     * Delete rule.
     *
     * @param \Fastmag\Sync\Api\Data\Rule\CarrierInterface $rule
     *
     * @return bool true on success
     *
     * @throws \Magento\Framework\Exception\CouldNotDeleteException
     */
    public function delete(CarrierInterface $rule);

    /**
     * Delete rule by ID.
     *
     * @param int $ruleId
     *
     * @return bool true on success
     *
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     * @throws \Magento\Framework\Exception\CouldNotDeleteException
     */
    public function deleteById($ruleId);
}
