<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-09-30
 ******************************************************************************/

namespace Fastmag\Sync\Process\Entity\ToMagento;

use Fastmag\Sync\Process\EntityInterface;
use Magento\Framework\DataObject;

/**
 * Class Order
 *
 * Entity class for order.
 * Save and transform data from Fastmag for Magento easy integration,
 * and transfer it from hydration worker to integration worker
 *
 * @method int|null getFastmagId()
 * @method int|null getStatus()
 * @method string|null getTrackingNumber()
 * @method string|null getCarrier()
 * @method Order setFastmagId(int $fastmagId)
 * @method Order setTrackingNumber(string $trackingNumber)
 * @method Order setCarrier(string $carrier)
 */
class Order extends DataObject implements EntityInterface
{
    /**
     * Set status as int
     *
     * @param string $status
     *
     * @return Order
     */
    public function setStatus($status)
    {
        return $this->setData('status', (int)substr($status, 0, 3));
    }

    /**
     * @inheritDoc
     */
    public function export()
    {
        $result = [
            'fastmag_id'      => $this->getFastmagId(),
            'status'          => $this->getStatus(),
            'carrier'         => $this->getCarrier(),
            'tracking_number' => $this->getTrackingNumber()
        ];

        return array_filter(
            $result,
            static function ($value) {
                return $value !== null && $value !== [];
            }
        );
    }
}
