<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-06-30
 ******************************************************************************/

namespace Fastmag\Sync\Block\Adminhtml\System\Config\Connection;

use Magento\Config\Block\System\Config\Form\Field;
use Magento\Framework\Data\Form\Element\AbstractElement;

/**
 * Class Proxy
 *
 * Config field block displaying SQL connection status
 */
class Proxy extends Field
{
    /** @var string $hostField */
    protected $hostField = 'fastmag_sync_connect_proxy_host';

    /** @var string $portField */
    protected $portField = 'fastmag_sync_connect_proxy_port';

    /** @var string $userField */
    protected $userField = 'fastmag_sync_connect_proxy_user';

    /** @var string $passwordField */
    protected $passwordField = 'fastmag_sync_connect_proxy_password';

    /** @var string $buttonLabel */
    protected $buttonLabel = 'Test connection';

    /** @var string $resultField */
    protected $resultField = 'test_connection_proxy_result';

    /** @var string $resultFieldPrefixId */
    protected $resultFieldPrefixId = 'result_fastmag_sync_connect_proxy_connection_';
    
    /**
     * Get host field name
     *
     * @return string
     */
    public function getHostField()
    {
        return $this->hostField;
    }

    /**
     * Get port field name
     *
     * @return string
     */
    public function getPortField()
    {
        return $this->portField;
    }

    /**
     * Get user field name
     *
     * @return string
     */
    public function getUserField()
    {
        return $this->userField;
    }

    /**
     * Get password field name
     *
     * @return string
     */
    public function getPasswordField()
    {
        return $this->passwordField;
    }

    /**
     * Get ID for field displaying the result of Fastmag API connection
     *
     * @return string
     */
    public function getResultField()
    {
        return $this->resultField;
    }

    /**
     * Get ID for field displaying the result of Fastmag API connection
     *
     * @param string $suffix
     *
     * @return string
     */
    public function getResultFieldId($suffix)
    {
        return $this->resultFieldPrefixId . $suffix;
    }

    /**
     * @inheritDoc
     */
    protected function _prepareLayout()
    {
        parent::_prepareLayout();
        $this->setTemplate('system/config/connection/proxy.phtml');

        return $this;
    }

    /**
     * Unset some non-related element parameters
     *
     * @param AbstractElement $element
     *
     * @return string
     */
    public function render(AbstractElement $element)
    {
        $element->unsScope()->unsCanUseWebsiteValue()->unsCanUseDefaultValue();
        return parent::render($element);
    }

    /**
     * Get the button and scripts contents
     *
     * @param AbstractElement $element
     *
     * @return string
     */
    protected function _getElementHtml(AbstractElement $element)
    {
        $originalData = $element->getOriginalData();
        $buttonLabel = !empty($originalData['button_label']) ? $originalData['button_label'] : $this->buttonLabel;
        $this->addData(
            [
                'button_label' => __($buttonLabel),
                'html_id'      => $element->getHtmlId(),
                'ajax_url'     => $this->_urlBuilder->getUrl('fastmagsync/system_config_connection/proxy'),
            ]
        );

        return $this->_toHtml();
    }
}
