<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-07-30
 ******************************************************************************/

namespace Fastmag\Sync\Model;

use FireGento\FastSimpleImport\Model\Importer as FireGentoImporter;

/**
 * Class Importer
 *
 * Overrides the FireGento Importer class to allow setters chaining and to add category path separator setter
 */
class Importer extends FireGentoImporter
{
    /**
     * @inheritDoc
     *
     * @return Importer
     */
    public function setEntityCode($entityCode)
    {
        $this->settings['entity'] = $entityCode;

        return $this;
    }

    /**
     * @inheritDoc
     *
     * @return Importer
     */
    public function setBehavior($behavior)
    {
        $this->settings['behavior'] = $behavior;

        return $this;
    }

    /**
     * @inheritDoc
     *
     * @return Importer
     */
    public function setIgnoreDuplicates($value)
    {
        $this->settings['ignore_duplicates'] = $value;

        return $this;
    }

    /**
     * @inheritDoc
     *
     * @return Importer
     */
    public function setValidationStrategy($strategy)
    {
        $this->settings['validation_strategy'] = $strategy;

        return $this;
    }

    /**
     * @inheritDoc
     *
     * @return Importer
     */
    public function setAllowedErrorCount($count)
    {
        $this->settings['allowed_error_count'] = $count;

        return $this;
    }

    /**
     * @inheritDoc
     *
     * @return Importer
     */
    public function setImportImagesFileDir($dir)
    {
        $this->settings['import_images_file_dir'] = $dir;

        return $this;
    }

    /**
     * Set category path separator
     *
     * @param string $separator
     *
     * @return Importer
     */
    public function setCategoryPathSeparator($separator)
    {
        $this->settings['category_path_seperator'] = $separator;

        return $this;
    }
}
