<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-07-23
 ******************************************************************************/

namespace Fastmag\Sync\Exception;

use Exception;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\Phrase;

/**
 * Class ApiException
 *
 * Class handling Fastmag API related errors
 */
class ApiException extends LocalizedException
{
    /** @var string $request */
    protected $request;

    /**
     * ApiException constructor.
     *
     * @param Phrase    $phrase
     * @param string    $request
     * @param Exception $cause
     * @param int       $code
     */
    public function __construct($phrase, $request = '', $cause = null, $code = 0)
    {
        parent::__construct($phrase, $cause, $code);

        $this->request = $request;
    }

    /**
     * Get raw request
     *
     * @return string
     */
    public function getRequest()
    {
        return $this->request;
    }
}
