<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-09-30
 ******************************************************************************/

namespace Fastmag\Sync\Model\Config\Source\Rule;

use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\Data\OptionSourceInterface;
use Magento\Store\Model\ScopeInterface;

/**
 * Class Carriers
 *
 * Source model getting all carriers available in Magento
 */
class Carriers implements OptionSourceInterface
{
    /** @var ScopeConfigInterface $scopeConfig */
    protected $scopeConfig;

    /** @var string[] $carriers */
    protected $carriers = [];

    /**
     * Carriers constructor
     *
     * @param ScopeConfigInterface $scopeConfig
     */
    public function __construct(ScopeConfigInterface $scopeConfig)
    {
        $this->scopeConfig = $scopeConfig;
    }

    /**
     * @inheritDoc
     */
    public function toOptionArray()
    {
        foreach ($this->getCarriers() as $carrierCode => $carrierLabel) {
            $options[] = [
                'value' => $carrierCode,
                'label' => $carrierLabel
            ];
        }

        return $options;
    }

    /**
     * Returns values as associative array
     *
     * @return array
     */
    public function toArray()
    {
        return $this->getCarriers();
    }

    /**
     * Get carriers list
     *
     * @return array
     */
    protected function getCarriers()
    {
        if (count($this->carriers) === 0) {
            $carriers = ['*' => __('All carriers')];
            $carrierCodes = array_keys($this->scopeConfig->getValue('carriers', ScopeInterface::SCOPE_STORE));

            foreach ($carrierCodes as $carrierCode) {
                $carrierTitle = $this->scopeConfig->getValue(
                    'carriers/' . $carrierCode . '/title',
                    ScopeInterface::SCOPE_STORE
                );

                $carriers[$carrierCode] = $carrierTitle;
            }

            $this->carriers = $carriers;
        }

        return $this->carriers;
    }
}
