<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-09-28
 ******************************************************************************/

namespace Fastmag\Sync\Process\Worker\ToMagento\Integration;

use Fastmag\Sync\Api\Jobqueue\ToMagentoRepositoryInterface as JobRepository;
use Fastmag\Sync\Api\OrderRepositoryInterface as SyncedOrderRepository;
use Fastmag\Sync\Logger\Logger;
use Fastmag\Sync\Model\Config;
use Fastmag\Sync\Process\Worker;
use Fastmag\Sync\Process\Worker\ToMagento\Integration as IntegrationTrait;
use Magento\Sales\Api\OrderRepositoryInterface as OrderRepository;

/**
 * Class Order
 *
 * Abstract class for Order related Integration workers
 */
abstract class Order extends Worker
{
    use IntegrationTrait;

    /** @var SyncedOrderRepository $syncedOrderRepository */
    protected $syncedOrderRepository;

    /** @var OrderRepository $orderRepository */
    protected $orderRepository;

    /**
     * Order constructor
     *
     * @param Logger                $logger
     * @param JobRepository         $jobRepository
     * @param Config                $config
     * @param SyncedOrderRepository $syncedOrderRepository
     * @param OrderRepository       $orderRepository
     */
    public function __construct(
        Logger $logger,
        JobRepository $jobRepository,
        Config $config,
        SyncedOrderRepository $syncedOrderRepository,
        OrderRepository $orderRepository
    ) {
        parent::__construct($logger);

        $this->jobRepository = $jobRepository;
        $this->config = $config;
        $this->syncedOrderRepository = $syncedOrderRepository;
        $this->orderRepository = $orderRepository;
    }
}
