<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-10-14
 ******************************************************************************/

namespace Fastmag\Sync\Ui\Component\Listing\Column\Jobqueue;

use Fastmag\Sync\Model\Config\Source\Jobqueue\Status as Source;
use Magento\Framework\UrlInterface;
use Magento\Framework\View\Asset\Repository;
use Magento\Framework\View\Element\UiComponent\ContextInterface;
use Magento\Framework\View\Element\UiComponentFactory;
use Magento\Ui\Component\Listing\Columns\Column;

/**
 * Class Status
 *
 * Column renderer for jobs status
 */
class Status extends Column
{
    /** @var Repository $assetRepo */
    protected $assetRepo;

    /** @var UrlInterface $urlBuilder */
    protected $urlBuilder;

    /** @var Source $source */
    protected $source;

    /**
     * Status constructor
     *
     * @param ContextInterface   $context
     * @param UiComponentFactory $uiComponentFactory
     * @param Repository         $assetRepo
     * @param UrlInterface       $urlBuilder
     * @param Source             $source
     * @param array              $components
     * @param array              $data
     */
    public function __construct(
        ContextInterface $context,
        Repository $assetRepo,
        UiComponentFactory $uiComponentFactory,
        UrlInterface $urlBuilder,
        Source $source,
        array $components = [],
        array $data = []
    ) {
        parent::__construct($context, $uiComponentFactory, $components, $data);

        $this->assetRepo = $assetRepo;
        $this->urlBuilder = $urlBuilder;
        $this->source = $source;
    }

    /**
     * Prepare Data Source
     *
     * @param array $dataSource
     *
     * @return array
     */
    public function prepareDataSource(array $dataSource)
    {
        if (isset($dataSource['data']['items'])) {
            foreach ($dataSource['data']['items'] as &$item) {
                $item[$this->getData('name')] = $this->prepareItem($item);
            }
        }

        return $dataSource;
    }

    /**
     * Get data
     *
     * @param array $item
     *
     * @return string
     */
    protected function prepareItem(array $item)
    {
        $status = $item['status'];
        $listStatuses = $this->source->toArray();

        if (!array_key_exists($status, $listStatuses)) {
            $content = __('Unknown');
        } else {
            $content = $listStatuses[$status];
        }

        return $content;
    }
}
