<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-08-03
 ******************************************************************************/

namespace Fastmag\Sync\Block\Adminhtml\Preconfig;

use Fastmag\Sync\Model\Config;
use Fastmag\Sync\Model\System\Connection\Sql\EdiSql;
use Magento\Backend\Block\Template;
use Magento\Backend\Block\Template\Context;

/**
 * Class Form
 *
 * Block class for form element on preconfig page
 */
class Form extends Template
{
    /** @var EdiSql $ediSql */
    protected $ediSql;

    /** @var Config $config */
    protected $config;

    /**
     * Form constructor.
     *
     * @param Context $context
     * @param EdiSql  $ediSql
     * @param Config  $config
     * @param array   $data
     */
    public function __construct(Context $context, EdiSql $ediSql, Config $config, array $data = [])
    {
        parent::__construct($context, $data);

        $this->ediSql = $ediSql;
        $this->config = $config;
    }

    /**
     * Returns data source (given by config field)
     *
     * @return string
     */
    public function getDataSource()
    {
        return $this->ediSql->getDataSource();
    }

    /**
     * Tells if all the config field needed are filled
     *
     * @return bool
     */
    public function isConfigSet()
    {
        return $this->config->isSetFlag(Config::XML_PATH_CONNECT_PROXY_USER)
            && $this->config->isSetFlag(Config::XML_PATH_CONNECT_PROXY_PASSWORD)
            && !is_null($this->getDataSource());
    }
}
