<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-09-18
 ******************************************************************************/

namespace Fastmag\Sync\Cron;

use Exception;
use Fastmag\Sync\Logger\Logger;
use Fastmag\Sync\Model\Config;
use Fastmag\Sync\Process\Manager\ToMagento as Manager;

/**
 * Class ProcessToMagento
 *
 * Cron class responsible for processing local ToMagento jobs queue
 */
class ProcessToMagento
{
    /** @var Logger $logger */
    protected $logger;

    /** @var Config $config */
    protected $config;

    /** @var Manager $manager */
    protected $manager;

    /**
     * ProcessToMagento constructor
     *
     * @param Logger  $logger
     * @param Config  $config
     * @param Manager $manager
     */
    public function __construct(Logger $logger, Config $config, Manager $manager)
    {
        $this->logger = $logger;
        $this->config = $config;
        $this->manager = $manager;
    }

    /**
     * Main method
     *
     * @throws Exception
     */
    public function execute()
    {
        $this->logger->debug('Beginning jobs queues processing');

        sleep($this->config->getValue(Config::XML_PATH_JOBQUEUE_ADVANCED_REACTIVITY));

        $this->manager->run();
    }
}
