<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-08-06
 ******************************************************************************/

namespace Fastmag\Sync\Model\Rule;

use Fastmag\Sync\Api\Data\Rule\TaxclassfamilyInterface;
use Fastmag\Sync\Model\ResourceModel\Rule\Taxclassfamily as ResourceModel;
use Magento\Framework\DataObject\IdentityInterface;
use Magento\Framework\Model\AbstractModel;

/**
 * Class Taxclassfamily
 *
 * Taxclassfamily rules model
 */
class Taxclassfamily extends AbstractModel implements TaxclassfamilyInterface, IdentityInterface
{
    /** @var string */
    public const CACHE_TAG = 'fastmag_sync_rule_taxclassfamily';

    /** @var string $_cacheTag */
    protected $_cacheTag = self::CACHE_TAG;

    /** @var string $_eventPrefix */
    protected $_eventPrefix = 'fastmag_sync_rule_taxclassfamily';

    /**
     * Ordertransaction constructor
     *
     * @return void
     */
    protected function _construct()
    {
        $this->_init(ResourceModel::class);
    }

    /**
     * @inheritDoc
     */
    public function getId()
    {
        return $this->getData(self::RULE_ID);
    }

    /**
     * @inheritDoc
     */
    public function getCreatedAt()
    {
        return $this->getData(self::CREATED_AT);
    }

    /**
     * @inheritDoc
     */
    public function getUpdatedAt()
    {
        return $this->getData(self::UPDATED_AT);
    }

    /**
     * @inheritDoc
     */
    public function getFamily()
    {
        return $this->getData(self::FAMILY);
    }

    /**
     * @inheritDoc
     */
    public function getTaxClassId()
    {
        return $this->getData(self::TAX_CLASS_ID);
    }

    /**
     * @inheritDoc
     */
    public function getIdentities()
    {
        return [self::CACHE_TAG . '_' . $this->getId()];
    }

    /**
     * @inheritDoc
     */
    public function setId($ruleId)
    {
        return $this->setData(self::RULE_ID, $ruleId);
    }

    /**
     * @inheritDoc
     */
    public function setFamily($family)
    {
        return $this->setData(self::FAMILY, $family);
    }

    /**
     * @inheritDoc
     */
    public function setTaxClassId($taxClassId)
    {
        return $this->setData(self::TAX_CLASS_ID, $taxClassId);
    }
}
