<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-09-30
 ******************************************************************************/

namespace Fastmag\Sync\Controller\Adminhtml\Rule\Taxclassfamily;

use Fastmag\Sync\Api\Rule\TaxclassfamilyRepositoryInterface as RuleRepository;
use Fastmag\Sync\Controller\Adminhtml\Rule\Taxclassfamily as ControllerAbstract;
use Magento\Backend\App\Action\Context;
use Magento\Backend\Model\View\Result\Page;
use Magento\Framework\App\Action\HttpGetActionInterface;
use Magento\Framework\App\Request\DataPersistorInterface;
use Magento\Framework\Controller\ResultInterface;
use Magento\Framework\View\Result\PageFactory;

/**
 * Class Index
 *
 * Taxclassfamily index action
 */
class Index extends ControllerAbstract implements HttpGetActionInterface
{
    /** @var PageFactory $resultPageFactory */
    protected $resultPageFactory;

    /**
     * Index constructor
     *
     * @param Context                $context
     * @param DataPersistorInterface $dataPersistor
     * @param RuleRepository         $ruleRepository
     * @param PageFactory            $resultPageFactory
     */
    public function __construct(
        Context $context,
        DataPersistorInterface $dataPersistor,
        RuleRepository $ruleRepository,
        PageFactory $resultPageFactory
    ) {
        parent::__construct($context, $dataPersistor, $ruleRepository);

        $this->resultPageFactory = $resultPageFactory;
    }

    /**
     * Display admin listing of the rules
     *
     * @return ResultInterface
     */
    public function execute()
    {
        /** @var Page $resultPage */
        $resultPage = $this->resultPageFactory->create();
        $this->initPage($resultPage)->getConfig()->getTitle()->prepend(__('Rules Tax Class/Family'));

        $this->dataPersistor->clear('taxclassfamily_rule');

        return $resultPage;
    }
}
