<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-11-03
 ******************************************************************************/

namespace Fastmag\Sync\Process\Worker\ToFastmag\Hydration\Customer;

use Fastmag\Sync\Api\Data\Jobqueue\ToFastmagInterface as Job;
use Fastmag\Sync\Exception\JobException;
use Fastmag\Sync\Exception\ProcessException;
use Fastmag\Sync\Process\Entity\ToFastmag\Customer as CustomerEntity;
use Fastmag\Sync\Process\Worker\ToFastmag\Hydration\Customer;

/**
 * Class Data
 *
 * Hydration class used for inserting or updating customers from Magento to Fastmag
 */
class Data extends Customer
{
    /** @inheritDoc */
    protected $code = 'tofastmag_hydration_customer';

    /** @inheritDoc */
    protected $subordinateWorkersAfter = ['tofastmag_hydration_customer_address'];

    /**
     * @inheritDoc
     */
    public function run()
    {
        $entities = false;

        try {
            $entities = $this->getDataFromMagento();
        } catch (ProcessException $exception) {
            foreach ($this->getJobs()->getItems() as $job) {
                $this->invalidateJob($job, $exception);
            }
        }

        if (is_array($entities)) {
            foreach ($entities as $customerId => $entity) {
                $job = $this->getJob($customerId);

                if ($job !== null) {
                    $this->hydrateJob($job, $entity);
                }
            }
        }

        foreach ($this->getJobs()->getItems() as $job) {
            $this->saveJob($job);
        }
    }

    /**
     * @inheritDoc
     *
     * @return CustomerEntity[]
     *
     * @throws ProcessException
     * @throws JobException
     */
    protected function getDataFromMagento()
    {
        $this->entities = [];
        $customersIds = $this->getJobs()->getColumnValues(Job::CONTENT_ID);

        foreach ($customersIds as $customerId) {
            $customerEntity = $this->customerEntityFactory->create();
            $customerEntity->setMagentoId($customerId);
            $this->entities[$customerId] = $customerEntity;
        }

        $this->getSyncedCustomers($customersIds);
        $this->getMagentoCustomersData($customersIds);

        return $this->entities;
    }
}
