<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-09-24
 ******************************************************************************/

namespace Fastmag\Sync\Plugin\Jobqueue\ToFastmag;

use Exception;
use Fastmag\Sync\Plugin\Jobqueue\ToFastmag;
use Magento\Sales\Api\Data\OrderInterface;
use Magento\Sales\Model\Order;

/**
 * Class OrderPlugin
 *
 * Plugin on Order
 */
class OrderPlugin extends ToFastmag
{
    /**
     * @see Order::cancel()
     *
     * @param Order          $subject
     * @param OrderInterface $result
     *
     * @return OrderInterface
     *
     * @throws Exception
     */
    public function afterCancel(Order $subject, $result)
    {
        if ($result->isCanceled()) {
            try {
                $key = $subject->getEntityId() . '_' . $subject->getStatus();

                $job = $this->jobFactory->create();
                $job->setContentId($key)
                    ->setJobCode('tofastmag_integration_order_cancellation');

                $this->jobRepository->save($job);
            } catch (Exception $exception) {
                $this->logger->error($exception->getMessage());
            }
        }

        return $result;
    }
}
