<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-10-27
 ******************************************************************************/

namespace Fastmag\Sync\Process\Worker\ToFastmag\Integration\Order;

use Fastmag\Sync\Api\Data\Rule\OrdertransactionInterface as OrdertransactionRule;
use Fastmag\Sync\Exception\JobException;
use Fastmag\Sync\Model\Config;
use Fastmag\Sync\Process\Entity\ToFastmag\Order as OrderEntity;
use Fastmag\Sync\Process\Worker\ToFastmag\Integration\Address as AbstractAddress;

/**
 * Class Address
 *
 * Integration class used for inserting or updating orders addresses from Magento to Fastmag
 */
class Address extends AbstractAddress
{
    /** @inheritDoc */
    protected $code = 'tofastmag_integration_order_address';

    /**
     * @inheritDoc
     */
    public function isEnabled()
    {
        return $this->config->isSetFlag(Config::XML_PATH_ORDER_EXPORT_ENABLE);
    }

    /**
     * @inheritDoc
     */
    protected function processJob($job)
    {
        /** @var OrderEntity $orderEntity */
        $orderEntity = $job->getEntity();

        if ($this->useCustomerData($orderEntity->getTransactionType())) {
            parent::processJob($job);
        }
    }

    /**
     * @inheritDoc
     */
    protected function getCustomerEntity($job)
    {
        /** @var OrderEntity $orderEntity */
        $orderEntity = $job->getEntity();

        $result = $orderEntity->getCustomer();
        if ($result === null) {
            throw new JobException(__('No customer for order #%1', $orderEntity->getIncrementId()));
        }

        $shippingAddress = $orderEntity->getShippingAddress();
        if ($shippingAddress === null) {
            throw new JobException(__('No shipping address for order #%1', $orderEntity->getIncrementId()));
        }

        $result->setShippingAddress($shippingAddress);

        return $result;
    }

    /**
     * Returns true if the transaction use customer data
     *
     * @param string|null $transactionType
     *
     * @return bool
     */
    protected function useCustomerData($transactionType)
    {
        return $transactionType === null || in_array(
            $transactionType,
            [
                OrdertransactionRule::FASTMAG_TRANSACTION_TYPE_SALE,
                OrdertransactionRule::FASTMAG_TRANSACTION_TYPE_RESERVATION,
                OrdertransactionRule::FASTMAG_TRANSACTION_TYPE_ORDER,
                OrdertransactionRule::FASTMAG_TRANSACTION_TYPE_RESERVATIONTOSALE
            ],
            true
        );
    }
}
