<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-12-28
 ******************************************************************************/

namespace Fastmag\Sync\Model\Worker\Hydration;

use Magento\Framework\ObjectManagerInterface as ObjectManager;

/**
 * Class PaymentFactory
 *
 * Factory class for payment extractor classes
 */
class PaymentFactory
{
    /** @var ObjectManager $objectManager */
    protected $objectManager;

    /** @var string[] $extractors */
    protected $extractors;

    /**
     * WorkerFactory constructor
     *
     * @param ObjectManager $objectManager
     * @param string[]      $extractors
     */
    public function __construct(ObjectManager $objectManager, array $extractors = [])
    {
        $this->objectManager = $objectManager;
        $this->extractors = $extractors;
    }

    /**
     * Create class instance with specified parameters
     *
     * @param string $method
     * @param array  $data
     *
     * @return Payment
     */
    public function create($method, array $data = [])
    {
        if (array_key_exists($method, $this->extractors)) {
            $instanceName = $this->extractors[$method];
        } else {
            $instanceName = $this->extractors['standard'];
        }

        return $this->objectManager->create($instanceName, $data);
    }
}
