# Fastmag plugin for Magento2
Use Fastmag's plugin for Magento 2 to allow you to interact with your Fastmag instance within Magento, and import or export data relative to your catalog.

## Requirements
This plugin supports Magento2 version 2.3.5 and higher.

## Installation
An authentication token is needed to download the package. It was or will be given to you by Home-Made.io.

You can set it as a global config, as an environment variable or interactively during Composer command:
```
composer config --global --auth http-basic.home-made-io.repo.packagist.com token TOKEN
```

```
COMPOSER_AUTH='{"http-basic": {"home-made-io.repo.packagist.com": {"username": "token", "password": "TOKEN"}}}'
```

```
Authentication required (home-made-io.repo.packagist.com):
Username: token
Password: TOKEN
```

You can install our plugin through Composer :
```
composer config repositories.private-packagist composer https://home-made-io.repo.packagist.com
composer require home-made-io/fastmag-sync-m2
bin/magento module:enable Fastmag_Sync
bin/magento setup:upgrade
```

However, if you prefer to do it manually, add to Magento composer.json the following lines in require and repositories sections:
```
"require": {
        "home-made-io/fastmag-sync-m2": "^1.0"
},
"repositories": [
    {
        "type": "composer",
        "url": "https://home-made-io.repo.packagist.com"
    }
],
```
Then run 
```
bin/magento module:enable Fastmag_Sync
bin/magento setup:upgrade
```

## Prerequisites
You have to enable SEO optimization for URL at least of the store where your customers will be imported.

https://blog.mdnsolutions.com/magento-2-remove-index-php-from-urls/

# User manual
## Commands

- `php/magento fastmag-sync:remote`: allows to synchronize the Fastmag jobqueue in the corresponding tables in Magento (fastmag_sync_jobqueue_to_magento and fastmag_sync_jobqueue_to_magento_scheduled)

```
$ bin/magento fastmag-sync:remote --help
   Description:
     Sync remote Fastmag jobs queue in Magento local jobs queues
   
   Usage:
     fastmag-sync:remote
   
   Options:
     -h, --help            Display this help message
```

- `bin/magento fastmag-sync:jobqueue`: allows to handle the local jobqueues, in Magento to Fastmag, Fastmag to Magento or both).

```
$ bin/magento fastmag-sync:jobqueue --help
Description:

  Process local jobs queues

Usage:
  fastmag-sync:jobqueue [options] [--] [<sync-way>]

Arguments:
  sync-way                   Sync way ("tofastmag", "tomagento", "both") [default: "both"]

Options:
  -c, --job-code[=JOB-CODE]  Job code
  -i, --job-id[=JOB-ID]      Job ID (in Magento DB)
  -h, --help                 Display this help message
```