<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-09-07
 ******************************************************************************/

namespace Fastmag\Sync\Model\Config\Source\Rule;

use Magento\Framework\Data\OptionSourceInterface;
use Magento\Sales\Model\Order\Status;
use Magento\Sales\Model\ResourceModel\Order\Status\Collection;
use Magento\Sales\Model\ResourceModel\Order\Status\CollectionFactory;

/**
 * Class OrderStatuses
 *
 * Source for order statutes
 */
class OrderStatuses implements OptionSourceInterface
{
    /** @var CollectionFactory $collectionFactory */
    protected $collectionFactory;

    /** @var Collection $collection */
    protected $collection;

    /**
     * PaymentMethods constructor
     *
     * @param CollectionFactory $collectionFactory
     */
    public function __construct(CollectionFactory $collectionFactory)
    {
        $this->collectionFactory = $collectionFactory;

        $this->collection = $this->collectionFactory->create();
    }

    /**
     * @inheritDoc
     */
    public function toOptionArray()
    {
        $options = [['value' => '*', 'label' => __('All order statuses')]];

        /** @var Status $status */
        foreach ($this->collection as $status) {
            $options[] = [
                'value' => $status->getStatus(),
                'label' => $status->getLabel()
            ];
        }

        return $options;
    }

    /**
     * Returns values as associative array
     *
     * @return array
     */
    public function toArray()
    {
        $options = ['*' => __('All order statuses')];

        /** @var Status $status */
        foreach ($this->collection as $status) {
            $options[$status->getStatus()] = $status->getLabel();
        }

        return $options;
    }
}
