<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2020 HOMEMADE.IO SAS
 * @date      2020-04-29
 ******************************************************************************/

namespace Fastmag\Sync\Api\Jobqueue;

use Fastmag\Sync\Api\Data\Jobqueue\ToMagentoScheduledInterface;
use Magento\Framework\Api\SearchCriteriaInterface;

/**
 * Interface ToMagentoScheduledRepositoryInterface
 */
interface ToMagentoScheduledRepositoryInterface
{
    /**
     * Save job.
     *
     * @param \Fastmag\Sync\Api\Data\Jobqueue\ToMagentoScheduledInterface $job
     *
     * @return \Fastmag\Sync\Api\Data\Jobqueue\ToMagentoScheduledInterface
     *
     * @throws \Magento\Framework\Exception\CouldNotSaveException
     */
    public function save(ToMagentoScheduledInterface $job);

    /**
     * Retrieve job.
     *
     * @param int $jobId
     *
     * @return \Fastmag\Sync\Api\Data\Jobqueue\ToMagentoScheduledInterface
     *
     * @throws \Magento\Framework\Exception\LocalizedException
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function getById($jobId);

    /**
     * Retrieve jobs matching the specified criteria.
     *
     * @param \Magento\Framework\Api\SearchCriteriaInterface $searchCriteria
     *
     * @return \Fastmag\Sync\Api\Data\Jobqueue\ToMagentoScheduledSearchResultsInterface
     */
    public function getList(SearchCriteriaInterface $searchCriteria);

    /**
     * Delete job.
     *
     * @param \Fastmag\Sync\Api\Data\Jobqueue\ToMagentoScheduledInterface $job
     *
     * @return bool true on success
     *
     * @throws \Magento\Framework\Exception\CouldNotDeleteException
     */
    public function delete(ToMagentoScheduledInterface $job);

    /**
     * Delete job by ID.
     *
     * @param int $jobId
     *
     * @return bool true on success
     *
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     * @throws \Magento\Framework\Exception\CouldNotDeleteException
     */
    public function deleteById($jobId);
}
