# Changelog
All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## Cheatsheet
### Changelog
    Added for new features.
    Changed for changes in existing functionality.
    Deprecated for soon-to-be removed features.
    Removed for now removed features.
    Fixed for any bug fixes.
    Security in case of vulnerabilities.

### Versionning
    MAJOR version when you make incompatible API changes,
    MINOR version when you add functionality in a backwards compatible manner, and
    PATCH version when you make backwards compatible bug fixes.

## Versions
### 1.1.2
#### Added
- Check products name before import
- Increment ID and link to order in Synced Orders grid
- Logs in transfers workers
- Logs at the end of the remote queue synchronization process

#### Fixed
- Add a specific suffix on URL key for simple products without size/color (to set a distinction with parent product)
- Reset jobs to Magento when the entity is updated on Fastmag
- Columns fixed in Synced Orders grid
- PHPMD.CouplingBetweenObjects warning suppression
- Send customer referer to Fastmag only on creation
- Link to edit page on order/transaction rules grid
- Code review

### 1.1.1
#### Fixed
- Clarify comment on "inventory_transfer" config field
- Change field use to set orders' status in Fastmag
- Stock transfers not sent multiple times if order is not synced
- Code review

### 1.1.0
#### Added
- Factory logic to get specific payment ID extractor class depending on payment method of the order synced

#### Fixed
- Code review

### 1.0.2
#### Added
- Add a comment on Fastmag API query on each item which have a discount

#### Fixed
- Substract discount amount to each item total row

### 1.0.1
#### Fixed
- Check order's synchronization history to avoid duplicating transactions in Fastmag when an order is saved in a status defined in Order/Transaction Rules