<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2020 HOMEMADE.IO SAS
 * @date      2020-08-22
 ******************************************************************************/

namespace Fastmag\Sync\Model;

use Fastmag\Sync\Api\Data\CustomerInterface;
use Fastmag\Sync\Model\ResourceModel\Customer as ResourceModel;
use Magento\Framework\DataObject\IdentityInterface;
use Magento\Framework\Model\AbstractModel;

/**
 * Class Customer
 *
 * Synchronized customers model
 */
class Customer extends AbstractModel implements CustomerInterface, IdentityInterface
{
    /** @var string */
    public const CACHE_TAG = 'fastmag_sync_customer';

    /** @var string $_cacheTag */
    protected $_cacheTag = self::CACHE_TAG;

    /**
     * Customer constructor
     *
     * @return void
     */
    protected function _construct()
    {
        $this->_init(ResourceModel::class);
    }

    /**
     * @inheritDoc
     */
    public function getId()
    {
        return $this->getData(self::SYNC_ID);
    }

    /**
     * @inheritDoc
     */
    public function getMagentoCustomerId()
    {
        return $this->getData(self::MAGENTO_CUSTOMER_ID);
    }

    /**
     * @inheritDoc
     */
    public function getFastmagCustomerId()
    {
        return $this->getData(self::FASTMAG_CUSTOMER_ID);
    }

    /**
     * @inheritDoc
     */
    public function getIsDeleted()
    {
        return $this->getData(self::IS_DELETED);
    }

    /**
     * @inheritDoc
     */
    public function getCreatedAt()
    {
        return $this->getData(self::CREATED_AT);
    }

    /**
     * @inheritDoc
     */
    public function getProcessedAt()
    {
        return $this->getData(self::PROCESSED_AT);
    }

    /**
     * @inheritDoc
     */
    public function getIdentities()
    {
        return [self::CACHE_TAG . '_' . $this->getId()];
    }

    /**
     * @inheritDoc
     */
    public function setId($syncId)
    {
        return $this->setData(self::SYNC_ID, $syncId);
    }

    /**
     * @inheritDoc
     */
    public function setMagentoCustomerId($magentoCustomerId)
    {
        return $this->setData(self::MAGENTO_CUSTOMER_ID, $magentoCustomerId);
    }

    /**
     * @inheritDoc
     */
    public function setFastmagCustomerId($fastmagCustomerId)
    {
        return $this->setData(self::FASTMAG_CUSTOMER_ID, $fastmagCustomerId);
    }

    /**
     * @inheritDoc
     */
    public function setIsDeleted($isDeleted)
    {
        return $this->setData(self::IS_DELETED, $isDeleted);
    }

    /**
     * @inheritDoc
     */
    public function setCreatedAt($createdAt)
    {
        return $this->setData(self::CREATED_AT, $createdAt);
    }

    /**
     * @inheritDoc
     */
    public function setProcessedAt($processedAt)
    {
        return $this->setData(self::PROCESSED_AT, $processedAt);
    }
}
