<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-10-28
 ******************************************************************************/

namespace Fastmag\Sync\Api\Jobqueue;

use Fastmag\Sync\Api\Data\Jobqueue\ToFastmagInterface;
use Magento\Framework\Api\SearchCriteriaInterface;

/**
 * Interface ToFastmagRepositoryInterface
 */
interface ToFastmagRepositoryInterface
{
    /**
     * Save job.
     *
     * @param \Fastmag\Sync\Api\Data\Jobqueue\ToFastmagInterface $job
     *
     * @return \Fastmag\Sync\Api\Data\Jobqueue\ToFastmagInterface
     *
     * @throws \Magento\Framework\Exception\CouldNotSaveException
     */
    public function save(ToFastmagInterface $job);

    /**
     * Retrieve job.
     *
     * @param int $jobId
     *
     * @return \Fastmag\Sync\Api\Data\Jobqueue\ToFastmagInterface
     *
     * @throws \Magento\Framework\Exception\LocalizedException
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function getById($jobId);

    /**
     * Retrieve jobs matching the specified criteria.
     *
     * @param \Magento\Framework\Api\SearchCriteriaInterface $searchCriteria
     *
     * @return \Fastmag\Sync\Api\Data\Jobqueue\ToFastmagSearchResultsInterface
     */
    public function getList(SearchCriteriaInterface $searchCriteria);

    /**
     * Retrieve jobs matching the specified criteria and group by job_code.
     *
     * @param \Magento\Framework\Api\SearchCriteriaInterface $searchCriteria
     * @param int                                            $limit
     *
     * @return array of \Fastmag\Sync\Api\Data\Jobqueue\ToFastmagSearchResultsInterface
     */
    public function getListByCode(SearchCriteriaInterface $searchCriteria, $limit);

    /**
     * Delete job.
     *
     * @param \Fastmag\Sync\Api\Data\Jobqueue\ToFastmagInterface $job
     *
     * @return bool true on success
     *
     * @throws \Magento\Framework\Exception\CouldNotDeleteException
     */
    public function delete(ToFastmagInterface $job);

    /**
     * Delete job by ID.
     *
     * @param int $jobId
     *
     * @return bool true on success
     *
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     * @throws \Magento\Framework\Exception\CouldNotDeleteException
     */
    public function deleteById($jobId);

    /**
     * Reset job
     *
     * @param \Fastmag\Sync\Api\Data\Jobqueue\ToFastmagInterface $job
     *
     * @return \Fastmag\Sync\Api\Data\Jobqueue\ToFastmagInterface
     */
    public function reset(ToFastmagInterface $job);

    /**
     * Hydrate job with entity
     *
     * @param \Fastmag\Sync\Api\Data\Jobqueue\ToFastmagInterface $job
     * @param \Fastmag\Sync\Process\EntityInterface              $entity
     *
     * @return \Fastmag\Sync\Api\Data\Jobqueue\ToFastmagInterface
     */
    public function hydrate(ToFastmagInterface $job, \Fastmag\Sync\Process\EntityInterface $entity);

    /**
     * Validate job
     *
     * @param \Fastmag\Sync\Api\Data\Jobqueue\ToFastmagInterface $job
     *
     * @return \Fastmag\Sync\Api\Data\Jobqueue\ToFastmagInterface
     */
    public function validate(ToFastmagInterface $job);

    /**
     * Invalidate job
     *
     * @param \Fastmag\Sync\Api\Data\Jobqueue\ToFastmagInterface $job
     * @param \Exception $exception
     *
     * @return \Fastmag\Sync\Api\Data\Jobqueue\ToFastmagInterface
     */
    public function invalidate(ToFastmagInterface $job, \Exception$exception);

    /**
     * Skip job
     *
     * @param \Fastmag\Sync\Api\Data\Jobqueue\ToFastmagInterface $job
     * @param \Exception $exception
     *
     * @return \Fastmag\Sync\Api\Data\Jobqueue\ToFastmagInterface
     */
    public function skip(ToFastmagInterface $job, \Exception $exception);
}
