<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2022 HOMEMADE.IO SAS
 * @date      2022-01-25
 ******************************************************************************/

namespace Fastmag\Sync\Model\Config\Source\Customer;

use Magento\Framework\Data\OptionSourceInterface;

/**
 * Class GroupField
 *
 * Source for customers group field
 */
class GroupField implements OptionSourceInterface
{
    public const VALUE_GENERAL  = 'general';
    public const VALUE_DISCOUNT = 'discount';
    public const VALUE_GROUPING = 'grouping';
    public const VALUE_BOTH     = 'both';

    /**
     * @inheritDoc
     */
    public function toOptionArray()
    {
        return [
            ['value' => self::VALUE_GENERAL, 'label' => __('Affect to the group "General"')],
            [
                'value' => self::VALUE_DISCOUNT,
                'label' => __('Affect to automatically created groups according to "Remise" field')
            ],
            [
                'value' => self::VALUE_GROUPING,
                'label' => __('Affect to automatically created groups according to "Regroupement" field')
            ],
            [
                'value' => self::VALUE_BOTH,
                'label' =>
                    __('Affect to automatically created groups according to both fields ("Regroupement", then "Remise")')
            ]
        ];
    }

    /**
     * Returns values as associative array
     *
     * @return array
     */
    public function toArray()
    {
        return [
            self::VALUE_GENERAL  => __('Affect to the group "General"'),
            self::VALUE_DISCOUNT => __('Affect to automatically created groups according to "Remise" field'),
            self::VALUE_GROUPING => __('Affect to automatically created groups according to "Regroupement" field'),
            self::VALUE_BOTH     =>
                __('Affect to automatically created groups according to both fields ("Regroupement", then "Remise")'),
        ];
    }
}
