<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-08-23
 ******************************************************************************/

namespace Fastmag\Sync\Process;

use Fastmag\Sync\Exception\ProcessException;
use Fastmag\Sync\Logger\Logger;

/**
 * Class Worker
 *
 * Class handling basic operation on the workers, and inherited to hydration and integration workers
 */
abstract class Worker
{
    /** @var Logger $logger */
    protected $logger;

    /** @var string $code */
    protected $code;

    /**
     * Worker constructor.
     *
     * @param Logger $logger
     */
    public function __construct(Logger $logger)
    {
        $this->logger = $logger;
    }

    /**
     * Get worker code
     *
     * @return string
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * Main method
     *
     * @return void
     *
     * @throws ProcessException
     */
    abstract public function run();
}
