<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-08-10
 ******************************************************************************/

namespace Fastmag\Sync\Setup\Patch\Data;

use Fastmag\Sync\Model\Config;
use Magento\Catalog\Model\ProductFactory;
use Magento\Framework\Api\SearchCriteriaBuilder;
use Magento\Framework\App\Config\Storage\WriterInterface;
use Magento\Framework\Exception\InputException;
use Magento\Framework\Setup\Patch\DataPatchInterface;
use Magento\Framework\Setup\Patch\PatchRevertableInterface;
use Magento\Tax\Api\TaxClassManagementInterface as TaxClassManagement;
use Magento\Tax\Api\TaxClassRepositoryInterface as TaxClassRepository;
use Magento\Tax\Model\ClassModel as TaxModel;

/**
 * Class InstallDefaultConfig
 *
 * Installer for specific default configs
 */
class InstallDefaultConfig implements DataPatchInterface, PatchRevertableInterface
{
    /** @var ProductFactory $productFactory */
    protected $productFactory;

    /** @var TaxClassRepository $taxClassRepository */
    protected $taxClassRepository;

    /** @var SearchCriteriaBuilder $searchCriteriaBuilder */
    protected $searchCriteriaBuilder;

    /** @var WriterInterface $configWriter */
    protected $configWriter;

    /** @var Config $config */
    protected $config;

    /**
     * InstallDefaultConfig constructor
     *
     * @param ProductFactory        $productFactory
     * @param TaxClassRepository    $taxClassRepository
     * @param SearchCriteriaBuilder $searchCriteriaBuilder
     * @param WriterInterface       $configWriter
     * @param Config                $config
     */
    public function __construct(
        ProductFactory $productFactory,
        TaxClassRepository $taxClassRepository,
        SearchCriteriaBuilder $searchCriteriaBuilder,
        WriterInterface $configWriter,
        Config $config
    ) {
        $this->productFactory = $productFactory;
        $this->taxClassRepository = $taxClassRepository;
        $this->searchCriteriaBuilder = $searchCriteriaBuilder;
        $this->configWriter = $configWriter;
        $this->config = $config;
    }

    /**
     * @inheritdoc
     */
    public static function getDependencies()
    {
        return [];
    }

    /**
     * @inheritdoc
     */
    public function getAliases()
    {
        return [];
    }

    /**
     * @inheritDoc
     */
    public function apply()
    {
        $defaultAttributeSetId = $this->productFactory->create()->getDefaultAttributeSetId();
        $this->configWriter->save(Config::XML_PATH_PRODUCT_IMPORT_ATTRIBUTE_SET_ID, $defaultAttributeSetId);
    }

    /**
     * @inheritDoc
     */
    public function revert()
    {
        $this->configWriter->delete(Config::XML_PATH_PRODUCT_IMPORT_ATTRIBUTE_SET_ID);
    }
}
