<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-08-02
 ******************************************************************************/

namespace Fastmag\Sync\Controller\Adminhtml;

use Fastmag\Sync\Logger\Logger;
use Fastmag\Sync\Model\Config;
use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Framework\App\Request\Http;
use Zend_Mail;
use Zend_Mail_Exception;

abstract class Preconfig extends Action
{
    /** @var string */
    public const ADMIN_RESOURCE = 'Fastmag_Sync::preconfig';

    /** @var Config $config */
    protected $config;

    /** @var Logger $logger */
    protected $logger;

    /** @var Zend_Mail $zendMail */
    protected $zendMail;

    /**
     * Preconfig constructor
     *
     * @param Context   $context
     * @param Config    $config
     * @param Logger    $logger
     * @param Zend_Mail $zendMail
     */
    public function __construct(
        Context $context,
        Config $config,
        Logger $logger,
        Zend_Mail $zendMail
    ) {
        parent::__construct($context);

        $this->config = $config;
        $this->logger = $logger;
        $this->zendMail = $zendMail;
    }

    /**
     * Returns email content
     *
     * @return string
     */
    protected function getEmailContent()
    {
        /** @var Http $request */
        $request = $this->getRequest();

        $httpHost = $request->getServer('HTTP_HOST');
        $externalIp = gethostbyname($httpHost);

        return 'Connexion Ace Preconfig' . PHP_EOL .
            '--------------------------------------------------' . PHP_EOL .
            'Date : ' . date('Y-m-d H:i:s') . PHP_EOL .
            'IP utilisateur : ' . $request->getServer('REMOTE_ADDR') . PHP_EOL .
            'IP serveur : ' . $request->getServer('SERVER_ADDR') . PHP_EOL .
            'IP externe : ' . $externalIp . PHP_EOL .
            'URL site : ' . $httpHost . PHP_EOL;
    }

    /**
     * @param string $emailFrom
     * @param string $emailTo
     * @param string $subject
     * @param string $content
     *
     * @throws Zend_Mail_Exception
     */
    protected function sendEmail($emailFrom, $emailTo, $subject, $content)
    {
        $this->zendMail->setSubject($subject);
        $this->zendMail->setBodyText($content);
        $this->zendMail->setFrom($emailFrom);
        $this->zendMail->addTo($emailTo);
        $this->zendMail->send();
    }
}
