<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-12-28
 ******************************************************************************/

namespace Fastmag\Sync\Model\Worker\Hydration;

use Fastmag\Sync\Model\Config;
use Magento\Sales\Api\Data\OrderInterface as OrderModel;

/**
 * Class Payment
 *
 * Class handling payment ID extraction, depending on the payment method
 */
abstract class Payment
{
    /** @var Config $config */
    protected $config;

    /** @var OrderModel $order */
    protected $order;

    /**
     * Payment constructor.
     *
     * @param Config     $config
     * @param OrderModel $order
     */
    public function __construct(Config $config, OrderModel $order)
    {
        $this->config = $config;
        $this->order = $order;
    }

    /**
     * Get payment ID
     *
     * @return string
     */
    public function getPaymentId()
    {
        $result = '';

        $payment = $this->order->getPayment();

        if ($payment !== null) {
            $result = $payment->getEntityId();

            if ($payment->getCcTransId()) {
                $result = $payment->getCcTransId();
            } elseif ($payment->getLastTransId()) {
                $result = $payment->getLastTransId();
            }
        }

        return $result;
    }
}
