<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2022 HOMEMADE.IO SAS
 * @date      2022-02-16
 ******************************************************************************/

namespace Fastmag\Sync\Ui\Component\Listing\Column\Customer;

use Magento\Framework\UrlInterface as UrlBuilder;
use Magento\Framework\View\Element\UiComponent\ContextInterface as UiComponentContext;
use Magento\Framework\View\Element\UiComponentFactory;
use Magento\Ui\Component\Listing\Columns\Column;

/**
 * Class CustomerId
 *
 * Column renderer for customer ID to link with matching edit page
 */
class CustomerId extends Column
{
    /** @var UrlBuilder $urlBuilder */
    protected $urlBuilder;

    /**
     * CustomerId constructor
     *
     * @param UiComponentContext $context
     * @param UiComponentFactory $uiComponentFactory
     * @param UrlBuilder         $urlBuilder
     * @param array              $components
     * @param array              $data
     */
    public function __construct(
        UiComponentContext $context,
        UiComponentFactory $uiComponentFactory,
        UrlBuilder $urlBuilder,
        array $components = [],
        array $data = []
    ) {
        parent::__construct($context, $uiComponentFactory, $components, $data);

        $this->urlBuilder = $urlBuilder;
    }

    /**
     * Prepare data source.
     *
     * @param array $dataSource
     *
     * @return array
     */
    public function prepareDataSource(array $dataSource)
    {
        if (isset($dataSource['data']['items'])) {
            foreach ($dataSource['data']['items'] as &$item) {
                $item[$this->getData('name')] = $this->prepareItem($item);
            }
        }

        return $dataSource;
    }

    /**
     * Get data
     *
     * @param array $item
     *
     * @return string
     */
    protected function prepareItem(array $item)
    {
        $fieldName = $this->getData('name');
        $html = $item[$fieldName];

        if (!empty($item[$fieldName])) {
            $html = '<a target="_blank" href="'
                . $this->urlBuilder->getUrl('customer/index/edit', ['id' => $item[$fieldName]]) . '">'
                . $item[$fieldName] . '</a>';
        }

        return $html;
    }
}
