<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-08-05
 ******************************************************************************/

namespace Fastmag\Sync\FastmagSetup;

/**
 * Class Uninstaller
 *
 * Class handling job queue and triggers deletion on Fastmag
 */
class Uninstaller
{
    /**
     * Get uninstallation queries
     *
     * @return array
     */
    public function getUninstallQueries()
    {
        $sql = ['triggers' => [], 'tables' => []];

        $sql['tables'] = ['DROP TABLE IF EXISTS fmsync_job_queue;'];

        $sql['triggers'] = [
             'DROP TRIGGER IF EXISTS trigger_fmsync_produitsfiches_update;',
             'DROP TRIGGER IF EXISTS trigger_fmsync_produitslangues_update;',
             'DROP TRIGGER IF EXISTS trigger_fmsync_produits_update;',
             'DROP TRIGGER IF EXISTS trigger_fmsync_produitstarifs_insert;',
             'DROP TRIGGER IF EXISTS trigger_fmsync_produitstarifs_update;',
             'DROP TRIGGER IF EXISTS trigger_fmsync_produitstarifs_delete;',
             'DROP TRIGGER IF EXISTS trigger_fmsync_produits_promo_insert;',
             'DROP TRIGGER IF EXISTS trigger_fmsync_produits_promo_update;',
             'DROP TRIGGER IF EXISTS trigger_fmsync_produits_promo_delete;',
             'DROP TRIGGER IF EXISTS trigger_fmsync_produits_promotc_insert;',
             'DROP TRIGGER IF EXISTS trigger_fmsync_produits_promotc_update;',
             'DROP TRIGGER IF EXISTS trigger_fmsync_produits_promotc_delete;',
             'DROP TRIGGER IF EXISTS trigger_fmsync_produits_prixqte_insert;',
             'DROP TRIGGER IF EXISTS trigger_fmsync_produits_prixqte_update;',
             'DROP TRIGGER IF EXISTS trigger_fmsync_produits_prixqte_delete;',
             'DROP TRIGGER IF EXISTS trigger_fmsync_produits_image_stock_insert;',
             'DROP TRIGGER IF EXISTS trigger_fmsync_produits_image_stock_update;',
             'DROP TRIGGER IF EXISTS trigger_fmsync_produits_image_stock_delete;',
             'DROP TRIGGER IF EXISTS trigger_fmsync_produits_stock_insert;',
             'DROP TRIGGER IF EXISTS trigger_fmsync_produits_stock_update;',
             'DROP TRIGGER IF EXISTS trigger_fmsync_vente_update;',
             'DROP TRIGGER IF EXISTS trigger_fmsync_produits_vente_insert;',
             'DROP TRIGGER IF EXISTS trigger_fmsync_produits_vente_update;',
             'DROP TRIGGER IF EXISTS trigger_fmsync_client_insert;',
             'DROP TRIGGER IF EXISTS trigger_fmsync_client_update;',
             'DROP TRIGGER IF EXISTS trigger_fmsync_client_addr_liv_insert;',
             'DROP TRIGGER IF EXISTS trigger_fmsync_client_addr_liv_update;',
             'DROP TRIGGER IF EXISTS trigger_fmsync_client_addr_liv_delete;',
        ];

        return $sql;
    }
}
