<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2020 HOMEMADE.IO SAS
 * @date      2020-12-15
 ******************************************************************************/

namespace Fastmag\Sync\Model\ResourceModel\Jobqueue;

use Fastmag\Sync\Api\Data\Jobqueue\ToFastmagInterface as ModelInterface;
use Fastmag\Sync\Model\Jobqueue\ToFastmag as Model;
use Magento\Framework\Model\AbstractModel;
use Magento\Framework\Model\ResourceModel\Db\AbstractDb;
use Magento\Framework\Model\ResourceModel\Db\Context;
use Magento\Framework\Serialize\Serializer\Json;

/**
 * Class ToFastmag
 *
 * Resource model for Fastmag to Magento job
 *
 * @method bool delete(ModelInterface $object)
 */
class ToFastmag extends AbstractDb
{
    /** @var Json $jsonSerializer */
    protected $jsonSerializer;

    /**
     * ToMagento constructor.
     *
     * @param Context     $context
     * @param Json        $jsonSerializer
     * @param string|null $connectionName
     */
    public function __construct(Context $context, Json $jsonSerializer, $connectionName = null)
    {
        parent::__construct($context, $connectionName);

        $this->jsonSerializer = $jsonSerializer;
    }

    /**
     * ToFastmag constructor
     *
     * @return void
     */
    protected function _construct()
    {
        $this->_init('fastmag_sync_jobqueue_to_fastmag', 'job_id');
    }

    /**
     * @inheritDoc
     *
     * Decode JSON hydrated data
     */
    public function load(AbstractModel $object, $value, $field = null)
    {
        parent::load($object, $value, $field);

        $dataJson = $object->getData(Model::HYDRATED_DATA);
        if ($dataJson !== null) {
            $object->setData(Model::HYDRATED_DATA, $this->jsonSerializer->unserialize($dataJson));
        }

        return $this;
    }

    /**
     * @inheritDoc
     *
     * Encode hydrated data
     */
    public function save(AbstractModel $object)
    {
        $data = $object->getData(Model::HYDRATED_DATA);
        if (is_array($data)) {
            $object->setData(Model::HYDRATED_DATA, $this->jsonSerializer->serialize($data));
        }

        parent::save($object);

        return $object->setData(Model::HYDRATED_DATA, $data);
    }
}
