<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2022 HOMEMADE.IO SAS
 * @date      2022-05-16
 ******************************************************************************/

namespace Fastmag\Sync\Model\Worker\Hydration\Payment;

use Fastmag\Sync\Model\Config;
use Fastmag\Sync\Model\Worker\Hydration\Payment;
use Magento\Framework\App\ObjectManager;
use Magento\Framework\Module\Manager as ModuleManager;
use Magento\Sales\Api\Data\OrderInterface as OrderModel;

/**
 * Class WorldpayCc
 *
 * Class giving the payment ID for standard payments methods
 */
class WorldpayCc extends Payment
{
    /** @var ModuleManager $moduleManager */
    protected $moduleManager;

    /** @var WorldpayPaymentFactory $worldpayPaymentFactory */
    protected $worldpayPaymentFactory;

    /**
     * WorldpayCc constructor.
     *
     * @param Config                 $config
     * @param OrderModel             $order
     * @param ModuleManager          $moduleManager
     */
    public function __construct(
        Config $config,
        OrderModel $order,
        ModuleManager $moduleManager
    ) {
        parent::__construct($config, $order);

        $this->moduleManager = $moduleManager;
    }

    /**
     * @inheritDoc
     */
    public function getPaymentId()
    {
        $result = '';

        $payment = $this->order->getPayment();

        if ($payment !== null) {
            if ($payment->getMethod() === 'worldpay_cc'
                && $this->moduleManager->isEnabled('Sapient_Worldpay')
                && $this->config->isSetFlag(Config::XML_PATH_ORDER_EXPORT_USE_WORLDPAY_ID)
            ) {
                // TODO : find a cleaner way
                $objectManager = ObjectManager::getInstance();
                $this->worldpayPaymentFactory = $objectManager->create('Sapient\Worldpay\Model\WorldpaymentFactory');

                $worldpayPayment = $this->worldpayPaymentFactory->create();
                $worldpayPayment->loadByPaymentId($this->order->getIncrementId());

                $result = $worldpayPayment->getWorldpayOrderId();
            } else {
                $result = parent::getPaymentId();
            }
        }

        return $result;
    }
}
