<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-06-07
 ******************************************************************************/

namespace Fastmag\Sync\Api\Data;

/**
 * Interface LogApiInterface
 */
interface LogApiInterface
{
    /** @var int */
    public const LOG_ID = 'log_id';

    /** @var string */
    public const ENDPOINT = 'endpoint';

    /** @var string */
    public const REQUEST = 'request';

    /** @var string */
    public const RESPONSE = 'response';

    /** @var string */
    public const CREATED_AT = 'created_at';

    /**
     * Get ID
     *
     * @return int|null
     */
    public function getId();

    /**
     * Get endpoint
     *
     * @return string|null
     */
    public function getEndpoint();

    /**
     * Get request
     *
     * @return string|null
     */
    public function getRequest();

    /**
     * Get response
     *
     * @return string|null
     */
    public function getResponse();

    /**
     * Get created at
     *
     * @return string|null
     */
    public function getCreatedAt();

    /**
     * Set ID
     *
     * @param int $logId
     *
     * @return \Fastmag\Sync\Api\Data\LogApiInterface
     */
    public function setId($logId);

    /**
     * Set endpoint
     *
     * @param string $endpoint
     *
     * @return \Fastmag\Sync\Api\Data\LogApiInterface
     */
    public function setEndpoint($endpoint);

    /**
     * Set request
     *
     * @param string $request
     *
     * @return \Fastmag\Sync\Api\Data\LogApiInterface
     */
    public function setRequest($request);

    /**
     * Set response
     *
     * @param string $response
     *
     * @return \Fastmag\Sync\Api\Data\LogApiInterface
     */
    public function setResponse($response);
}
