<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-09-29
 ******************************************************************************/

namespace Fastmag\Sync\Model\Rule;

use Fastmag\Sync\Api\Data\Rule\PaymentcodeInterface;
use Fastmag\Sync\Model\ResourceModel\Rule\Paymentcode as ResourceModel;
use Magento\Framework\DataObject\IdentityInterface;
use Magento\Framework\Model\AbstractModel;

/**
 * Class Paymentcode
 *
 * Paymentcode rules model
 */
class Paymentcode extends AbstractModel implements PaymentcodeInterface, IdentityInterface
{
    /** @var string */
    public const CACHE_TAG = 'fastmag_sync_rule_paymentcode';

    /** @var string $_cacheTag */
    protected $_cacheTag = self::CACHE_TAG;

    /** @var string $_eventPrefix */
    protected $_eventPrefix = 'fastmag_sync_rule_paymentcode';

    /**
     * Paymentcode constructor
     *
     * @return void
     */
    protected function _construct()
    {
        $this->_init(ResourceModel::class);
    }

    /**
     * @inheritDoc
     */
    public function getId()
    {
        return $this->getData(self::RULE_ID);
    }

    /**
     * @inheritDoc
     */
    public function getPaymentMethod()
    {
        return $this->getData(self::PAYMENT_METHOD);
    }

    /**
     * @inheritDoc
     */
    public function getFastmagCode()
    {
        return $this->getData(self::FASTMAG_CODE);
    }

    /**
     * @inheritDoc
     */
    public function getCreatedAt()
    {
        return $this->getData(self::CREATED_AT);
    }

    /**
     * @inheritDoc
     */
    public function getUpdatedAt()
    {
        return $this->getData(self::UPDATED_AT);
    }

    /**
     * @inheritDoc
     */
    public function getIdentities()
    {
        return [self::CACHE_TAG . '_' . $this->getId()];
    }

    /**
     * @inheritDoc
     */
    public function setId($ruleId)
    {
        return $this->setData(self::RULE_ID, $ruleId);
    }

    /**
     * @inheritDoc
     */
    public function setPaymentMethod($paymentMethod)
    {
        return $this->setData(self::PAYMENT_METHOD, $paymentMethod);
    }

    /**
     * @inheritDoc
     */
    public function setFastmagCode($fastmagCode)
    {
        return $this->setData(self::FASTMAG_CODE, $fastmagCode);
    }
}
