<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2022 HOMEMADE.IO SAS
 * @date      2022-02-23
 ******************************************************************************/

namespace Fastmag\Sync\Process\Worker\ToFastmag\Hydration\Customer;

use Fastmag\Sync\Api\Data\Jobqueue\ToFastmagInterface as Job;
use Fastmag\Sync\Exception\JobException;
use Fastmag\Sync\Exception\ProcessException;
use Fastmag\Sync\Process\Entity\ToFastmag\Customer as CustomerEntity;
use Fastmag\Sync\Process\Worker\ToFastmag\Hydration\Customer;

/**
 * Class Data
 *
 * Hydration class used for inserting or updating customers from Magento to Fastmag
 */
class Data extends Customer
{
    /** @inheritDoc */
    protected $code = 'tofastmag_hydration_customer';

    /** @inheritDoc */
    protected $subordinateWorkersAfter = ['tofastmag_hydration_customer_address'];

    /**
     * @inheritDoc
     */
    public function run()
    {
        $entities = false;

        try {
            $entities = $this->getDataFromMagento();
        } catch (ProcessException $exception) {
            foreach ($this->getJobs()->getItems() as $job) {
                $this->invalidateJob($job, $exception);
                $this->saveJob($job);
            }
        }

        if (is_array($entities)) {
            foreach ($this->getJobs()->getItems() as $job) {
                if (array_key_exists($job->getContentId(), $entities)) {
                    $this->hydrateJob($job, $entities[$job->getContentId()]);
                } else {
                    $exception = new JobException(__('No matching customer found for job'));
                    $this->skipJob($job, $exception);
                }

                $this->saveJob($job);
            }
        }
    }

    /**
     * @inheritDoc
     *
     * @return CustomerEntity[]
     *
     * @throws ProcessException
     * @throws JobException
     */
    protected function getDataFromMagento()
    {
        $this->entities = [];
        $customersIds = $this->getJobs()->getColumnValues(Job::CONTENT_ID);

        foreach ($customersIds as $customerId) {
            $customerEntity = $this->customerEntityFactory->create();
            $customerEntity->setMagentoId($customerId);
            $this->entities[$customerId] = $customerEntity;
        }

        $this->getSyncedCustomers($customersIds);
        $this->getMagentoCustomersData($customersIds);

        return $this->entities;
    }
}
