<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2020 HOMEMADE.IO SAS
 * @date      2020-08-22
 ******************************************************************************/

namespace Fastmag\Sync\Api\Data;

/**
 * Interface CustomerInterface
 */
interface CustomerInterface
{
    /** @var string */
    public const SYNC_ID = 'sync_id';

    /** @var string */
    public const MAGENTO_CUSTOMER_ID = 'magento_customer_id';

    /** @var string */
    public const FASTMAG_CUSTOMER_ID = 'fastmag_customer_id';

    /** @var string */
    public const IS_DELETED = 'is_deleted';

    /** @var string */
    public const CREATED_AT = 'created_at';

    /** @var string */
    public const PROCESSED_AT = 'processed_at';

    /**
     * Get ID
     *
     * @return int|null
     */
    public function getId();

    /**
     * Get Magento customer ID
     *
     * @return int|null
     */
    public function getMagentoCustomerId();

    /**
     * Get Fastmag customer ID
     *
     * @return int|null
     */
    public function getFastmagCustomerId();

    /**
     * Get is deleted token
     *
     * @return bool|null
     */
    public function getIsDeleted();

    /**
     * Get created at
     *
     * @return string|null
     */
    public function getCreatedAt();

    /**
     * Get processed at
     *
     * @return string|null
     */
    public function getProcessedAt();

    /**
     * Set ID
     *
     * @param int $syncId
     *
     * @return \Fastmag\Sync\Api\Data\CustomerInterface
     */
    public function setId($syncId);

    /**
     * Set Magento customer ID
     *
     * @param int $magentoCustomerId
     *
     * @return \Fastmag\Sync\Api\Data\CustomerInterface
     */
    public function setMagentoCustomerId($magentoCustomerId);

    /**
     * Set Fastmag customer ID
     *
     * @param int $fastmagCustomerId
     *
     * @return \Fastmag\Sync\Api\Data\CustomerInterface
     */
    public function setFastmagCustomerId($fastmagCustomerId);

    /**
     * Set is deleted token
     *
     * @param bool $isDeleted
     *
     * @return \Fastmag\Sync\Api\Data\CustomerInterface
     */
    public function setIsDeleted($isDeleted);

    /**
     * Set created at
     *
     * @param string $createdAt
     *
     * @return \Fastmag\Sync\Api\Data\CustomerInterface
     */
    public function setCreatedAt($createdAt);

    /**
     * Set processed at
     *
     * @param string $processedAt
     *
     * @return \Fastmag\Sync\Api\Data\CustomerInterface
     */
    public function setProcessedAt($processedAt);
}
