<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-09-27
 ******************************************************************************/

namespace Fastmag\Sync\Api\Data\Jobqueue;

/**
 * Interface ToFastmagInterface
 */
interface ToFastmagInterface
{
    /** @var string */
    public const JOB_ID = 'job_id';

    /** @var string */
    public const CONTENT_ID = 'content_id';

    /** @var string */
    public const JOB_CODE = 'job_code';

    /** @var string */
    public const STATUS = 'status';

    /** @var string */
    public const RETRY_COUNT = 'retry_count';

    /** @var string */
    public const CREATED_AT = 'created_at';

    /** @var string */
    public const PROCESSED_AT = 'processed_at';

    /** @var string */
    public const HYDRATED_DATA = 'hydrated_data';

    /** @var string */
    public const MESSAGE = 'message';

    /** @var string */
    public const TRACE = 'trace';

    /** @var string */
    public const ENTITY = 'entity';

    /**
     * Get ID
     *
     * @return int|null
     */
    public function getId();

    /**
     * Get content ID
     *
     * @return int|null
     */
    public function getContentId();

    /**
     * Get job code
     *
     * @return string|null
     */
    public function getJobCode();

    /**
     * Get status
     *
     * @return string|null
     */
    public function getStatus();

    /**
     * Get retry count
     *
     * @return int|null
     */
    public function getRetryCount();

    /**
     * Get created at
     *
     * @return string|null
     */
    public function getCreatedAt();

    /**
     * Get processed at
     *
     * @return string|null
     */
    public function getProcessedAt();

    /**
     * Get hydrated_data
     *
     * @return array|null
     */
    public function getHydratedData();

    /**
     * Get error message
     *
     * @return string|null
     */
    public function getMessage();

    /**
     * Get error trace
     *
     * @return string|null
     */
    public function getTrace();

    /**
     * Get entity
     *
     * @return \Fastmag\Sync\Process\EntityInterface
     */
    public function getEntity();

    /**
     * Set ID
     *
     * @param int $jobId
     *
     * @return \Fastmag\Sync\Api\Data\Jobqueue\ToFastmagInterface
     */
    public function setId($jobId);

    /**
     * Set content ID
     *
     * @param int $contentId
     *
     * @return \Fastmag\Sync\Api\Data\Jobqueue\ToFastmagInterface
     */
    public function setContentId($contentId);

    /**
     * Set job code
     *
     * @param string $jobCode
     *
     * @return \Fastmag\Sync\Api\Data\Jobqueue\ToFastmagInterface
     */
    public function setJobCode($jobCode);

    /**
     * Set status
     *
     * @param string $status
     *
     * @return \Fastmag\Sync\Api\Data\Jobqueue\ToFastmagInterface
     */
    public function setStatus($status);

    /**
     * Set retry count
     *
     * @param int $retryCount
     *
     * @return \Fastmag\Sync\Api\Data\Jobqueue\ToFastmagInterface
     */
    public function setRetryCount($retryCount);

    /**
     * Set created at
     *
     * @param string $createdAt
     *
     * @return \Fastmag\Sync\Api\Data\Jobqueue\ToFastmagInterface
     */
    public function setCreatedAt($createdAt);

    /**
     * Set processed at
     *
     * @param string $processedAt
     *
     * @return \Fastmag\Sync\Api\Data\Jobqueue\ToFastmagInterface
     */
    public function setProcessedAt($processedAt);

    /**
     * Set hydrated data
     *
     * @param array $hydratedData
     *
     * @return \Fastmag\Sync\Api\Data\Jobqueue\ToFastmagInterface
     */
    public function setHydratedData($hydratedData);

    /**
     * Set error message
     *
     * @param string $message
     *
     * @return \Fastmag\Sync\Api\Data\Jobqueue\ToFastmagInterface
     */
    public function setMessage($message);

    /**
     * Set error trace
     *
     * @param string $trace
     *
     * @return \Fastmag\Sync\Api\Data\Jobqueue\ToFastmagInterface
     */
    public function setTrace($trace);
}
