<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2022 HOMEMADE.IO SAS
 * @date      2022-03-25
 ******************************************************************************/

namespace Fastmag\Sync\Api\Rule;

use Fastmag\Sync\Api\Data\Rule\TaxclassfamilyInterface;
use Magento\Framework\Api\SearchCriteriaInterface;

/**
 * Interface TaxclassfamilyRepositoryInterface
 */
interface TaxclassfamilyRepositoryInterface
{
    /**
     * Save rule.
     *
     * @param \Fastmag\Sync\Api\Data\Rule\TaxclassfamilyInterface $rule
     *
     * @return \Fastmag\Sync\Api\Data\Rule\TaxclassfamilyInterface
     *
     * @throws \Magento\Framework\Exception\CouldNotSaveException
     */
    public function save(TaxclassfamilyInterface $rule);

    /**
     * Retrieve rule.
     *
     * @param int $ruleId
     *
     * @return \Fastmag\Sync\Api\Data\Rule\TaxclassfamilyInterface
     *
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function getById($ruleId);

    /**
     * Retrieve rules matching the specified criteria.
     *
     * @param \Magento\Framework\Api\SearchCriteriaInterface $searchCriteria
     *
     * @return \Fastmag\Sync\Api\Data\Rule\TaxclassfamilySearchResultsInterface
     */
    public function getList(SearchCriteriaInterface $searchCriteria);

    /**
     * Delete rule.
     *
     * @param \Fastmag\Sync\Api\Data\Rule\TaxclassfamilyInterface $rule
     *
     * @return bool true on success
     *
     * @throws \Magento\Framework\Exception\CouldNotDeleteException
     */
    public function delete(TaxclassfamilyInterface $rule);

    /**
     * Delete rule by ID.
     *
     * @param int $ruleId
     *
     * @return bool true on success
     *
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     * @throws \Magento\Framework\Exception\CouldNotDeleteException
     */
    public function deleteById($ruleId);
}
