<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-09-10
 ******************************************************************************/

namespace Fastmag\Sync\Model\Config\Source\Rule;

use Magento\Framework\Data\OptionSourceInterface;
use Magento\Payment\Helper\Data;

/**
 * Class PaymentMethods
 *
 * Source for payment methods
 */
class PaymentMethods implements OptionSourceInterface
{
    /** @var Data $paymentHelper */
    protected $paymentHelper;

    /** @var array $paymentsList */
    protected $paymentsList;

    /**
     * PaymentMethods constructor
     *
     * @param Data $paymentHelper
     */
    public function __construct(Data $paymentHelper)
    {
        $this->paymentHelper = $paymentHelper;

        $this->paymentsList = $this->paymentHelper->getPaymentMethodList();
    }

    /**
     * @inheritDoc
     */
    public function toOptionArray()
    {
        $options = [['value' => '*', 'label' => __('All payment methods')]];

        foreach ($this->paymentsList as $code => $title) {
            $options[] = [
                'value' => $code,
                'label' => $title . ' (' . $code . ')'
            ];
        }

        return $options;
    }

    /**
     * Returns values as associative array
     *
     * @return array
     */
    public function toArray()
    {
        $options = ['*' => __('All payment methods')];

        foreach ($this->paymentsList as $code => $title) {
            $options[$code] = $title . ' (' . $code . ')';
        }

        return $options;
    }
}
