<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2020 HOMEMADE.IO SAS
 * @date      2020-04-29
 ******************************************************************************/

namespace Fastmag\Sync\Model\ResourceModel;

use Fastmag\Sync\Api\Data\CustomerInterface as ModelInterface;
use Fastmag\Sync\Model\Customer as Model;
use Magento\Framework\DB\Select;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\Model\ResourceModel\Db\AbstractDb;

/**
 * Class Customer
 *
 * Synchronized customers model resource
 *
 * @method ModelInterface save(ModelInterface $object)
 * @method bool delete(ModelInterface $object)
 */
class Customer extends AbstractDb
{
    /**
     * Customer constructor
     *
     * @return void
     */
    protected function _construct()
    {
        $this->_init('fastmag_sync_customer', 'sync_id');
    }

    /**
     * Load customer with Magento ID
     *
     * @param Model $customer
     * @param int   $magentoId
     *
     * @return $this
     *
     * @see AbstractDb::load
     *
     * @throws LocalizedException
     */
    public function loadByMagentoId($customer, $magentoId)
    {
        $connection = $this->getConnection();

        if ($connection && $magentoId !== null) {
            $select = $this->_getLoadByMagentoId($magentoId);
            $data = $connection->fetchRow($select);

            if ($data) {
                $customer->setData($data);
            }
        }

        $this->unserializeFields($customer);
        $this->_afterLoad($customer);
        $customer->afterLoad();
        $customer->setOrigData();
        $customer->setHasDataChanges(false);

        return $this;
    }

    /**
     * Retrieve select customer for load object data by Magento ID
     *
     * @param int $magentoId
     *
     * @return Select
     *
     * @see AbstractDb::_getLoadSelect
     *
     * @throws LocalizedException
     */
    protected function _getLoadByMagentoId($magentoId)
    {
        $fastmagIdField = $this->getConnection()
            ->quoteIdentifier(sprintf('%s.%s', $this->getMainTable(), ModelInterface::MAGENTO_CUSTOMER_ID));

        return $this->getConnection()->select()->from($this->getMainTable())
            ->where($fastmagIdField . ' = ?', $magentoId);
    }

    /**
     * Load customer with Fastmag ID
     *
     * @param Model $customer
     * @param int   $fastmagId
     *
     * @return $this
     *
     * @see AbstractDb::load
     *
     * @throws LocalizedException
     */
    public function loadByFastmagId($customer, $fastmagId)
    {
        $connection = $this->getConnection();

        if ($connection && $fastmagId !== null) {
            $select = $this->_getLoadByFastmagId($fastmagId);
            $data = $connection->fetchRow($select);

            if ($data) {
                $customer->setData($data);
            }
        }

        $this->unserializeFields($customer);
        $this->_afterLoad($customer);
        $customer->afterLoad();
        $customer->setOrigData();
        $customer->setHasDataChanges(false);

        return $this;
    }

    /**
     * Retrieve select customer for load object data by Fastmag ID
     *
     * @param int $fastmagId
     *
     * @return Select
     *
     * @see AbstractDb::_getLoadSelect
     *
     * @throws LocalizedException
     */
    protected function _getLoadByFastmagId($fastmagId)
    {
        $fastmagIdField = $this->getConnection()
            ->quoteIdentifier(sprintf('%s.%s', $this->getMainTable(), ModelInterface::FASTMAG_CUSTOMER_ID));

        return $this->getConnection()->select()->from($this->getMainTable())
            ->where($fastmagIdField . ' = ?', $fastmagId);
    }
}
