<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-09-24
 ******************************************************************************/

namespace Fastmag\Sync\Process\Entity\ToFastmag\Order;

use Fastmag\Sync\Process\EntityInterface;
use Magento\Framework\DataObject;

/**
 * Class Transfer
 *
 * Entity class for transfer.
 * Save and transform data from Magento for Fastmag easy integration,
 * and transfer it from hydration worker to integration worker
 *
 * @method int|null getSyncId()
 * @method int|null getTransactionId()
 * @method string|null getRequest()
 * @method string|null getStatus()
 * @method string|null getOriginShop()
 * @method string|null getTargetShop()
 * @method Transfer setSyncId(int $syncId)
 * @method Transfer setTransactionId(int $transactionId)
 * @method Transfer setRequest(string $request)
 * @method Transfer setStatus(string $status)
 * @method Transfer setOriginShop(string $originShop)
 * @method Transfer setTargetShop(string $targetShop)
 */
class Transfer extends DataObject implements EntityInterface
{
    /**
     * @inheritDoc
     */
    public function export()
    {
        $result = [
            'sync_id'        => $this->getSyncId(),
            'transaction_id' => $this->getTransactionId(),
            'request'        => $this->getRequest(),
            'status'         => $this->getStatus(),
            'origin_shop'    => $this->getOriginShop(),
            'target_shop'    => $this->getTargetShop()
        ];

        return array_filter(
            $result,
            static function ($value) {
                return $value !== null && $value !== [];
            }
        );
    }
}
