<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2022 HOMEMADE.IO SAS
 * @date      2022-05-16
 ******************************************************************************/

namespace Fastmag\Sync\Process;

use Fastmag\Sync\Exception\ProcessException;
use Magento\Framework\ObjectManagerInterface as ObjectManager;

/**
 * Class WorkerFactory
 *
 * Factory class for worker
 *
 * @see \Magento\Framework\View\Element\UiComponent\DataProvider\CollectionFactory
 */
class WorkerFactory
{
    /** @var ObjectManager $objectManager */
    protected $objectManager;

    /** @var string[] $workers */
    protected $workers;

    /**
     * WorkerFactory constructor
     *
     * @param ObjectManager $objectManager
     * @param string[]      $workers
     */
    public function __construct(ObjectManager $objectManager, array $workers = [])
    {
        $this->objectManager = $objectManager;
        $this->workers = $workers;
    }

    /**
     * Create class instance with specified parameters
     *
     * @param string $jobCode
     * @param array  $data
     *
     * @return Worker
     *
     * @throws ProcessException
     */
    public function create($jobCode, array $data = [])
    {
        if (array_key_exists($jobCode, $this->workers)) {
            $workerClass = $this->workers[$jobCode];
        } else {
            throw new ProcessException(__('Workers for jobs "%1" are not defined', $jobCode));
        }

        return $this->objectManager->create($workerClass, $data);
    }
}
