<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2020 HOMEMADE.IO SAS
 * @date      2020-04-29
 ******************************************************************************/

namespace Fastmag\Sync\Controller\Adminhtml\Jobqueue\Tomagento;

use Fastmag\Sync\Api\Jobqueue\ToMagentoRepositoryInterface;
use Fastmag\Sync\Model\ResourceModel\Jobqueue\ToMagento\CollectionFactory;
use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Backend\Model\View\Result\Redirect;
use Magento\Framework\App\Action\HttpPostActionInterface;
use Magento\Framework\Controller\ResultFactory;
use Magento\Framework\Exception\CouldNotDeleteException;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Ui\Component\MassAction\Filter;

/**
 * Class MassDelete
 *
 * ToMagento jobs queue MassDelete action
 */
class MassDelete extends Action implements HttpPostActionInterface
{
    /** @var string */
    public const ADMIN_RESOURCE = 'Fastmag_Sync::jobqueue_tomagento';

    /** @var Filter $filter */
    protected $filter;

    /** @var CollectionFactory $collectionFactory */
    protected $collectionFactory;

    /** @var ToMagentoRepositoryInterface $jobRepository */
    protected $jobRepository;

    /**
     * MassDelete constructor
     *
     * @param Context $context
     * @param Filter $filter
     * @param CollectionFactory $collectionFactory
     * @param ToMagentoRepositoryInterface $jobRepository
     */
    public function __construct(
        Context $context,
        Filter $filter,
        CollectionFactory $collectionFactory,
        ToMagentoRepositoryInterface $jobRepository
    ) {
        parent::__construct($context);

        $this->filter = $filter;
        $this->collectionFactory = $collectionFactory;
        $this->jobRepository = $jobRepository;
    }

    /**
     * Execute action
     *
     * @return Redirect
     *
     * @throws LocalizedException
     * @throws CouldNotDeleteException
     * @throws NoSuchEntityException
     */
    public function execute()
    {
        $collection = $this->filter->getCollection($this->collectionFactory->create());
        $collectionSize = $collection->getSize();

        foreach ($collection->getAllIds() as $jobId) {
            $this->jobRepository->deleteById($jobId);
        }

        $this->messageManager->addSuccessMessage(__('A total of %1 job(s) have been deleted.', $collectionSize));

        /** @var Redirect $resultRedirect */
        $resultRedirect = $this->resultFactory->create(ResultFactory::TYPE_REDIRECT);
        return $resultRedirect->setPath('*/*/');
    }
}
