<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2022 HOMEMADE.IO SAS
 * @date      2022-08-19
 ******************************************************************************/

namespace Fastmag\Sync\Model\ResourceModel\Jobqueue\ToFastmag\Grid;

use Fastmag\Sync\Model\ResourceModel\Jobqueue\ToFastmag\Collection as JobCollection;
use Magento\Framework\Api\Search\AggregationInterface as SearchAggregation;
use Magento\Framework\Api\Search\SearchResultInterface;
use Magento\Framework\Api\SearchCriteriaInterface as SearchCriteria;
use Magento\Framework\Data\Collection\Db\FetchStrategyInterface as FetchStrategy;
use Magento\Framework\Data\Collection\EntityFactoryInterface as EntityFactory;
use Magento\Framework\DB\Adapter\AdapterInterface as DbAdapter;
use Magento\Framework\Event\ManagerInterface as EventManager;
use Magento\Framework\Model\ResourceModel\Db\AbstractDb;
use Magento\Framework\View\Element\UiComponent\DataProvider\Document;
use Psr\Log\LoggerInterface as Logger;

/**
 * Class Collection
 *
 * ToFastmag jobs model collection for admin grid
 */
class Collection extends JobCollection implements SearchResultInterface
{
    /** @var SearchAggregation $aggregations */
    protected $aggregations;

    /**
     * Collection constructor
     *
     * @param EntityFactory         $entityFactory
     * @param Logger                $logger
     * @param FetchStrategy         $fetchStrategy
     * @param EventManager          $eventManager
     * @param string                $mainTable
     * @param string                $eventPrefix
     * @param string                $eventObject
     * @param string                $resourceModel
     * @param string                $model
     * @param DbAdapter|string|null $connection
     * @param AbstractDb|null       $resource
     *
     * @SuppressWarnings(PHPMD.ExcessiveParameterList)
     */
    public function __construct(
        EntityFactory $entityFactory,
        Logger $logger,
        FetchStrategy $fetchStrategy,
        EventManager $eventManager,
        $mainTable,
        $eventPrefix,
        $eventObject,
        $resourceModel,
        $model = Document::class,
        $connection = null,
        AbstractDb $resource = null
    ) {
        parent::__construct(
            $entityFactory,
            $logger,
            $fetchStrategy,
            $eventManager,
            $connection,
            $resource
        );

        $this->_eventPrefix = $eventPrefix;
        $this->_eventObject = $eventObject;
        $this->_init($model, $resourceModel);
        $this->setMainTable($mainTable);
    }

    /**
     * @inheritDoc
     */
    public function getAggregations()
    {
        return $this->aggregations;
    }

    /**
     * @inheritDoc
     */
    public function setAggregations($aggregations)
    {
        $this->aggregations = $aggregations;

        return $this;
    }

    /**
     * @inheritDoc
     */
    public function getSearchCriteria()
    {
        return null;
    }

    /**
     * @inheritDoc
     */
    public function setSearchCriteria(SearchCriteria $searchCriteria = null)
    {
        return $this;
    }

    /**
     * @inheritDoc
     */
    public function getTotalCount()
    {
        return $this->getSize();
    }

    /**
     * @inheritDoc
     */
    public function setTotalCount($totalCount)
    {
        return $this;
    }

    /**
     * @inheritDoc
     */
    public function setItems(array $items = null)
    {
        return $this;
    }

    /**
     * Add increment_id of the order linked, if the job is on an order
     *
     * @inheritdoc
     */
    protected function _initSelect()
    {
        parent::_initSelect();

        $this->getSelect()
            ->columns('so.increment_id')
            ->joinLeft(
                ['so' => $this->getTable('sales_order')],
                'so.entity_id = main_table.content_id',
                []
            );

        $this->addFilterToMap('job_status', 'main_table.status');
    }
}
